G 	%TITLE "DECTALK-ACT-DEMO.BAS  --  BASIC APPLICATION GUIDELINE PROGRAM"   !  !			  ACT_DEMO.BAS   !  7  !	NOTE:  This program was written with VAX BASIC V3.0.   !E  !  The following file contains a "modifiable" demonstration program  F  !  to be included in the DECtalk Application Development Guide.  ThisF  !  demonstration program typifies most telephone application programsI  !  written for DECtalk.  It is written in VAX BASIC and uses Version 4.5 G  !  or later of the VMS/MicroVMS Run-Time Library Support provided for    !  DECtalk.  !C  !	Program description:  In the "MENU" subroutine there is a SELECT =  !		statement where the code determines which of 5 menu items :  !		are chosen.  The menu choices and menu message must be9  !		modified to reflect the menu items being implemented.   !		The menu choices are:   !  !			A) BANKING   !			B) FIELD SERVICE   !			C) DISTRIBUTION  !			D) LABOR REPORTING #  !			E) DECTALK PRODUCT INFORMATION   !			F) FINANCIAL INFORMATION   !			G) INFORMATION SERVICES  !			H) SOFTWARE SUPPORT  !C  !	NOTE:	The first five menu items have been chosen as the default.   !@  !		All error messages are logged only to the operator terminals>  !		that have specified that the "OPER11" type of message will>  !		be handled. These messages give the error message, and the;  !		terminal line connected to that process.  To have error C  !		messages logged to the console terminal, or any other terminal, :  !		at the DCL prompt ($), enter the REPLY/ENABLE command:  !  !			$ reply/enable=oper11  !A  !		To enter this command, you must have the OPER user privelege.   !    %INCLUDE "DTKDEF"  (  EXTERNAL LONG CONSTANT	STS$M_SUCCESS, & 			SS$_NORMAL,   & 			SS$_TIMEOUT  !8  !  EXTERNAL Run-time Library Routines (DECtalk support)  !  EXTERNAL LONG FUNCTION & 0 			DTK$ANSWER_PHONE,	! Wait for phone to ring !&2 			DTK$INITIALIZE, 	! Initialize DECtalk device !&3 			DTK$TERMINATE, 		! End initialized DECtalk use!&  			initialize_dectalk   !  !  Prompts and demo text   !5   COMMON (MESSAGE_TEXT) STRING  msg_access   = 100, &  				msg_invalid  = 40, & 				msg_bad_command   = 40, &  				msg_no_terminator  = 100, &  				msg_timeout  = 50, & 				customer_service = 160, &  				dispatch_desk = 160   N    msg_access   = "Please enter your access code followed by the pound-key." &* 		+ " You may enter any number as a test."6    msg_invalid  = "Invalid entry.  Please try again. "C    msg_timeout  = "No key pressed in the timeout period specified." <    msg_bad_command  = "Invalid command.  Please try again. "I    msg_no_terminator= "Please remember to terminate your entry with the"& % 		+ "pound-key.  Command accepted.  " M   customer_service = "In an actual application, DECtalk would now transfer "& I 	+ "your call to a customer service representative. This demonstration "& ) 	+ "just returns to the selection menu. " J   dispatch_desk = "In an actual application, DECtalk would now transfer "&9 	+ "your call to the dispatch-desk. This demonstration "& ) 	+ "just returns to the selection menu. "   P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &7 		     LONG	MAX_ENTRY, T1SECOND, T2SECOND, T20SECOND, & # 					T30SECOND, T5MINUTE, T15MINUTE   I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, & P         period_pause_duration, speech_on, new_mode, number_of_rings, keypad_mode  1   COMMON (application_specific)	LONG		voice_id, &  						num_hold_keys, & 						num_input_keys, &  					BYTE	hold_key_buf(80) , & 						input_key_buf(80), &( 					STRING	dictionary_file_name = 80, & 						terminal_line  	MAX_ENTRY = 3
 	T1SECOND = 1 
 	T2SECOND = 2  	T20SECOND = 20  	T30SECOND = 30  	T5MINUTE = 300  	T15MINUTE = 900 	TIME_45_SEC = "0 00:00:45"  	TIME_90_SEC = "0 00:01:30"  	TIME_6_MIN  = "0 00:06:00"  	TIME_16_MIN = "0 00:16:00"  	voice = DTK$K_VOICE_MALE  	speaking_rate = 180 	comma_pause_duration = 0  	period_pause_duration = 0 	speech_on = DTK$K_SPEAK 	new_mode = DTK$M_SQUARE  	keypad_mode = DTK$K_KEYPAD_AUTO  P    msg_welcome$  = "Welcome to DECtalk.  Digital Voice Solutions can increase "&+  		+ "your business [prowdaxkt'ihvixtiy]. "     %page  ! main   -  DECLARE LONG	version, init_dtk, need_to_init   init_dtk = 0%  need_to_init = 0% 	!A 	! Get the name of the physical device that the DECtalk module is B 	! connected to and the name of the dictionary file (if specified)A 	! that contains DECtalk's user dictionary words. If the call to  - 	! DTK$INITIALIZE is unsuccessful, then exit.  	!9 	CALL get_cli_params(terminal_line, dictionary_file_name)    	call set_timer(Time_45_sec)9 	stat% = DTK$INITIALIZE(voice_id, terminal_line, version)  	call cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN  		CALL error_log(stat%) 5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit  	END IF     WHILE_LOOP: 	WHILE 1% = 1%			! do always   	num_hold_keys = 0%  	num_input_keys = 0%  9 	 !  Check to see if the DECtalk needs to be initialized. < 	 !  (init_dtk = need_to_init = 0).  If so, reinitialize theC  	 !  application specific parameters.  Then, set a watchdog timer  B 	 !  for 16 minutes in the future in case the DECtalk module fails@ 	 !  and no response to the DTK$ANSWER_PHONE command is received> 	 !  from DECtalk.  ** NOTE:  MAKE SURE THE WATCHDOG TIMER IS : 	 !  ALWAYS SET TO A VALUE LARGER THAN THE TIMEOUT PERIOD C 	 !  SPECIFIED IN THE DTK$ANSWER_PHONE COMMAND.  THE WATCHDOG TIMER / 	 !  CAN BE LARGER THAN 16 MINUTES.  Next, wait B 	 !  for the phone connected to the DECtalk to ring.  If the phone? 	 !  does not ring in "timeout" seconds (or the watchdog timer  B 	 !  times out), normally, the status of the DECtalk unit would beA 	 !  checked.  This is not possible in the current version (V4.5) A 	 !  of the VMS Run-Time Library Support for DECtalk.  Therefore, H 	 !  instead of reinitializing DECtalk every time the unit power cycled,C 	 !  it is reinitialized every time no phone calls are received in  G 	 !  "timeout" seconds. Then, a greeting message is spoken to the user. 
          ! 	IF init_dtk = need_to_init @ 	THEN  stat% = initialize_dectalk		! Reinitialize DECtalk paramS# 		IF (STAT% AND STS$M_SUCCESS) = 0%  		THEN- 			!  Initialization failed.  It appears that 0 			!  the DECtalk module may be dead.  For now,  			!  I will exit.    			GO TO out			! End the program 		END IF9 	    init_dtk = NOT need_to_init			! Appl. init. complete  	END IF ; 	CALL set_timer(time_16_min)		! Set system (watchdog) timer  	!G 	! The greeting message DECtalk speaks upon answering the telephone can ; 	! be modified by changing the text in the character string A 	! "msg_welcome". The number of rings DECtalk waits to answer the F 	! telephone ("number_of_rings"), can be changed but it is recommended7 	! that the phone is always answered on the first ring.  	!K         stat% = DTK$ANSWER_PHONE(voice_id, number_of_rings, msg_welcome$, &  								T15MINUTE) 	CALL cancel_timer 	IF (stat% = SS$_NORMAL) 	THEN  		! ' 		!  The telephone has been answered.    		! A 		!  NOTE: DTK$ANSWER_PHONE automatically enables autostop keypad 6 		!	 mode, and wink detection on the telephone keypad. 		!  		CALL menu  		CALL end_call 9 	ELSE IF (stat% = SS$_TIMEOUT)			! Timeout period expired 
 	     THEN2 		init_dtk = need_to_init			! Have to reinitialize
 	     ELSE 		CALL error_log(stat%) 6 		CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exit 	     END IF 	END IF      NEXT    out:A     !  some fatal error has occured... Terminate DECtalk and exit      !      CALL set_timer(Time_45_sec) C     stat% = DTK$TERMINATE(VOICE_ID)     ! End use of DECtalk device      CALL cancel_timer %     IF (stat% AND STS$M_SUCCESS) = 0%      THEN 		CALL error_log(stat%) 
     END IF     END  N  !********************* END OF PROGRAM ***************************************  !C  ! Gets the parameters from the command line using LIB$GET_FOREIGN. C  ! If a fatal error occurs, it is reported and the demo is stopped. K  ! Otherwise, the parameters specified are returned in terminal_line_string P  ! for the device name, and dictionary_name for the name of the dictionary file.  !A  SUB  get_cli_params (STRING device_name, STRING dictionary_name)M  % 	EXTERNAL LONG CONSTANT STS$M_SUCCESSw' 	EXTERNAL LONG FUNCTION LIB$GET_FOREIGN    	DECLARE STRING get_param_bufa0 	DECLARE LONG device_length, diction_name_length  * 	stat% = LIB$GET_FOREIGN(get_param_buf,,,)" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENs 		CALL error_log(stat%)r6 		CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exit 	END IFu+ 	device_length = POS(get_param_buf, " ", 1)r) 	diction_name_length = LEN(get_param_buf)    	IF device_length = 0% 	THENs: 		device_name = SEG$(get_param_buf,1, diction_name_length) 	ELSEn9 		device_name = SEG$(get_param_buf, 1, device_length - 1) 9 		dictionary_name = SEG$(get_param_buf, device_length+1,&i 						 diction_name_length)s 	END IFp	   END SUB     K  !************************************************************************* ?  !  Initializes the application specific parameters of DECtalk.ND  !  First, left square bracket ('[') and right square bracket (']') M  !  are enabled as phonemic delimiters. To specify other modes, the bit maskscM  !  for the modes to be set should be OR'd together with the DTK$M_SQUARE bittM  !  mask and assigned to the varible "NEW_MODE".  Next, the default speaking !H  !  voice and speaking rate are selected for the application.  The commaE  !  pause and period pause are set to DECtalk defaults.  Other voicesoI  !  can selected for the default speaking voice by modifying the variableeB  !  "voice".  Likewise, a different speaking rate can be specifiedG  !  by changing the static variable "speaking_rate".  Finally, the user F  !  dictionary is loaded (by invoking "load_dictionary").  Note, otherF  !  application specific parameters should also be initialized in this"  !  subroutine if the need arises.  !  #  FUNCTION LONG initialize_dectalk()o  &   EXTERNAL LONG CONSTANT	STS$M_SUCCESS(   EXTERNAL LONG FUNCTION	DTK$SET_MODE, & 				DTK$SET_VOICE, & 				load_dictionary	  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min   I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, & - 		 period_pause_duration, speech_on, new_mode	-   COMMON (application_specific)	LONG	voice_id1   	CALL set_timer(Time_45_sec)+ 	stat% = DTK$SET_MODE(voice_id, new_mode, )s 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENu 		CALL error_log(stat%)i6 		CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exit 	END IF  	!A 	!  Indicate the type of voice and the speaking rate for DECtalk.  	CALL set_timer(Time_45_sec)7 	stat% = DTK$SET_VOICE(voice_id, voice, speaking_rate &m1 				,comma_pause_duration, period_pause_duration)a 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENn 		CALL error_log(stat%)f6 		CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exit 	END IFd 	!8 	! load user dictionary using "load_dictionary" function 	!% 	initialize_dectalk = load_dictionary, 	EXIT FUNCTION
  END FUNCTION   K  !  ----------------------------------------------------------------------- O  !  Gets a series of touch tone keys entered on the telephone keypad terminatediM  !  by a pound sign (#) or an asterisk (*).  Returns SUCCESS if the series of O  !  touch tone keys was received successfully.  Otherwise, FAILURE is returned.e  N  FUNCTION LONG get_key_string(STRING prompt,LONG timeout,LONG terminator_code)    %INCLUDE "DTKDEF"  +   EXTERNAL LONG FUNCTION	DTK$READ_KEYSTROKEc'   EXTERNAL LONG CONSTANT	SS$_TIMEOUT, &, 				SS$_NORMAL, &_
 				DTK$_WINKB  P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &) 		     LONG	MAX_ENTRY, T1SECOND, T2SECONDY  1    COMMON (application_specific)	LONG	voice_id, &  						num_hold_keys, & 						num_input_keys, &= 					BYTE	hold_key_buf(80), &5 						input_key_buf(80)0  C   DECLARE LONG  read_key_buf, hold_buf_ptr, ad_timeout, loc_timeouti   	loc_timeout = timeout   	IF num_hold_keys > 0% 	THENd 	!E 	!  There are Touch Tone keys in the typeahead buffer (hold_key_buf).dB 	!  The routine "read_advance_keys" is called here to read any newA 	!  keys pressed.  This is used mainly to read and process winks. F 	!  The "keys" stored in the typeahead buffer are moved into the input? 	!  buffer "input_key_buf" up to any terminator character.  The_H 	!  terminator character is put in "terminator_value", and any remainingG 	!  characters left in the typeahead buffer are copied to the front of f 	!  the buffer.t 	! 		ad_timeout = 1%t 		GOSUB read_advance_keyso" 		hold_key_buf(num_hold_keys) = 0% 		hold_buf_ptr = 0%CA 		WHILE hold_key_buf(hold_buf_ptr) <> DTK$K_TRM_NUMBER_SIGN AND &e8 		      hold_key_buf(hold_buf_ptr) <> DTK$K_TRM_ASTERISK  % 			IF hold_key_buf(hold_buf_ptr) = 0%r 			THENa 				num_hold_keys = 0% 				GO TO read_key	 			END IFa% 				input_key_buf(num_input_keys) = &  					hold_key_buf(hold_buf_ptr)   ' 			num_input_keys = num_input_keys + 1% # 			hold_buf_ptr = hold_buf_ptr + 1%y 		NEXT. 		terminator_code = hold_key_buf(hold_buf_ptr)" 		hold_buf_ptr = hold_buf_ptr + 1% 		num_hold_keys = 0% 		!t9 		!  Recopy the remaining keys in the typeahead buffer toeA 		!  the beginning of the buffer.  If the terminating keycode was A 		!  a "#" or "*", skip over it and start recopying with the nextc
 		!  keycode.v 	 ' 		UNTIL hold_key_buf(hold_buf_ptr) = 0%H9 			hold_key_buf(num_hold_keys)=hold_key_buf(hold_buf_ptr)N% 			num_hold_keys = num_hold_keys + 1% % 			hold_buf_ptr  = hold_buf_ptr  + 1%H 		NEXT 		GO TO process_entryT 	END IFN 	IF LEN(prompt) > 1% 	THENtB 	!  this test assumes that no 1 character prompts will be sent to 9 	!  dectalk.  Prompts of 1 char will be passed over here.  	!% 		CALL speak_text(DTK$K_WAIT, prompt)C 	END IF 
  read_key: 	WHILE 1% = 1% 		!n? 		!  Read all keys entered on the touch tone keypad by the useriA 		!  and store them in the typeahead buffer "hold_key_buf". Firstt> 		!  a watchdog timer must be set before any keys can be read.	          d 		CALL set_timer(Time_45_sec)rC 		stat% = DTK$READ_KEYSTROKE(voice_id, read_key_buf, , loc_timeout)k 		CALL cancel_timer  		IF stat% = SS$_NORMALe 		THEN0 			IF (read_key_buf = DTK$K_TRM_NUMBER_SIGN OR &) 			    read_key_buf = DTK$K_TRM_ASTERISK)U 			THEN0 				!H+ 				!  Received key string terminator ("#")t2 				!  so reception of keystring is completed. Use1 				!  a short timeout to gather up any remainingp+ 				!  touch tone keys entered by the user._  " 				terminator_code = read_key_buf 				ad_timeout = 2%i 				GOSUB read_advance_keysc 				GO TO process_entryg 			ELSEe0 				input_key_buf(num_input_keys) = read_key_buf( 				num_input_keys = num_input_keys + 1% 				loc_timeout = 10% 	 			END IFe 		ELSE	IF stat% = SS$_TIMEOUTt 			THEN  				EXIT read_keyt 			ELSE	IF stat% = DTK$_WINK 				THEN 				!t. 				!  DECtalk detected a wink which sometimes0 				!  indicates that the user has hungup.  This0 				!  demonstration program assumes that a WINK, 				!  does indicate the a user has hungup. 2 				!  Therefore, return so DECtalk can hangup its3 				!  phone.  If for any reason it is noticed thatD3 				!  spontaneous winks are occurring and the user 0 				!  at the other end of the telephone did not0 				!  hangup, then DO NOT return. Just continue! 				!  receiving touch tone keys.o   				    CALL error_log(stat%)	 				    get_key_string = 0%a  				    EXIT FUNCTION 				ELSE 				    CALL error_log(stat%)L% 				    CALL LIB$STOP(stat% BY VALUE)s
 				END IF	 			END IFE 		END IF 	NEXT 	         ! N         !  No keystring terminator ("#" or "*") entered so set the terminatingJ         !  keycode to DTK$K_TRM_TIMEOUT.  Otherwise, return all touch toneF 	!  keys entered. Finally, recopy any remaining touch tone keys in the= 	!  typeahead buffer (ttkeys) to the beginning of the buffer. 	          !$ 	terminator_code = DTK$K_TRM_TIMEOUT    PROCESS_ENTRY:*! 	hold_key_buf(num_hold_keys) = 0% 
 	CALL restart  	get_key_string = 1% 	EXIT FUNCTION    READ_ADVANCE_KEYS:  	!G 	!  Read any keys from DECtalk into the typeahead buffer "hold_key_buf"s 	!
 	WHILE 1=1 		CALL set_timer(Time_45_sec) B 		stat% = DTK$READ_KEYSTROKE(voice_id, read_key_buf, , ad_timeout) 		CALL cancel_timerS 		IF stat% = SS$_NORMALG 		THEN- 			hold_key_buf(num_hold_keys) = read_key_bufG% 			num_hold_keys = num_hold_keys + 1%G 		ELSE	IF stat% = SS$_TIMEOUTD# 			THEN				! no key pressed: returnE
 				RETURN 			ELSE	IF stat% = DTK$_WINK 				THEN			! Hung up?  exitt 					CALL error_log(stat%) 					get_key_string = 0%  					EXIT FUNCTIONg 				ELSE 					CALL error_log(stat%)" 					CALL LIB$STOP(stat% BY VALUE)
 				END IF	 			END IFg 		END IF 	NEXT,  
  END FUNCTIONm    M  !***************************************************************************eL  ! Verifies the access code received from the customer.  This routine alwaysD  ! returns SUCCESS for the purpose of this demonstration.  In a realP  ! application, the code would be verified against access codes in the database.    FUNCTION LONG access_verify ()n   	access_verify = 1%T 	EXIT FUNCTION  
  END FUNCTIONo  M  !***************************************************************************NH  ! Verifies the password received from the customer. This routine alwaysD  ! returns SUCCESS for the purpose of this demonstration.  In a realL  ! application, the password would be verified against their password in the  ! database.  !  FUNCTION LONG password_verify ()i   	password_verify = 1%g 	EXIT FUNCTION
  END FUNCTION   M  !*************************************************************************** G  !  Prompts the user for a command and receives the command (touch tonelJ  !  key) from the user.  Note, the command will be accepted whether or notE  !  it is terminated with the pound key "#".  However, if the commandhG  !  is not followed by the pound key, the command will not be processed O  !  until the timeout period has expired and a warning message has been spoken.oM  !  When commands are received, the routine "process_menu_entry" is performedn!  !  to implement the menu choice.e  !  SUB menu()i    %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT STS$M_SUCCESS)   EXTERNAL LONG FUNCTION	DTK$SET_VOICE, &  				get_key_string, &  				banking, & 				field_service, & 				distribution, &k 				labor_reporting, & 				financial_info, &i 				info_servicesn  5   COMMON (MESSAGE_TEXT) STRING  msg_access   = 100, &f 				msg_invalid  = 40, & 				msg_bad_command   = 40, &r 				msg_no_terminator  = 100, &  				msg_timeout  = 50, & 				customer_service = 160  P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &4 		     LONG	MAX_ENTRY, T1SECOND, T2SECOND, T20SECOND  I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, &e 				 period_pause_duration  0   COMMON (application_specific)	LONG	voice_id, & 					num_hold_keys, &  					num_input_keys, & 				BYTE	hold_key_buf(80), & 					input_key_buf(80)  M   main_menu_msg$ = "Please enter a command.  For help, press 0 followed by "&D1 		+ "the pound-key. To exit, press the star-key."%  M   main_menu$	= "To hear about DECtalk in banking, Press 1, followed by the "&iH 	+ "pound-key. To hear a field-service application, Press 2, followed "&H 	+ "by the pound-key.  To hear a distribution-demonstration, Press 3, "&I 	+ "followed by the pound-key.  To hear a time-reporting demonstration,"& < 	+ " Press 4, followed by the pound-key.  To hear DECtalk "&@ 	+ "product-information, press 5, followed by the pound-key.  "&C 	+ "To repeat this message, Press 0, followed by the pound-key.  "& " 	+ "To exit, Press the star-key. "  L   dtcfamily$	= "[+] The [`]DECtalk [`]Voice Response-System is the latest "&I 	+ "addition to Digital's Voice solutions. It features the performance "&tD 	+ "of the MicroVAX 2, plus the flexibility of the foremost voice "&F 	+ "synthesis product on the market today.  The [`]DECtalk [`]Voice "&F 	+ "Response-System is sized to support from 2 to 32 DEctalk lines. "&H 	+ "It is ideally suited to front end large data-bases. Packaged with "&I 	+ "the [`]DECtalk [`]Voice Response-System is the DECtalk Application "&NE 	+ "Development-Guide.  This guide consists of a user's manual and "& C 	+ "sample application-software. It is designed to significantly "&eG 	+ "reduce the time required to develop a voice response application "&iI 	+ "for any of the DEctalk products. DECtalk component products include"&_H 	+ " Dual-Line DECtalk, a two-line subsystem, and Multi-line DECtalk, "&D 	+ "an eight-line subsystem, both of which are rack mountable. In "&F 	+ "addition, the DECtalk board can be used to expand the number of "&H 	+ "lines needed.  [+] Single line DECtalk is a table-top unit with a "&> 	+ "built-in loud-speaker. It is best for [st'aend#axl`own] "&I 	+ "applications, such as aids for the handicapped. It is also commonly"&oI 	+ " used in manufacturing, for [m'aonaxtaxrixnx] status on the factory"&_H 	+ " floor. [+] All DECtalk products appropriately pronounce commonly "&E 	+ "occurring forms, such as numbers, money, abbreviations, dates, "&t& 	+ "times, and [paxnxkchuw'eyshaxn]. "  O   soft_support$	= "There are three options for software-development. Digital "&kC 	+ "Software Services, Third party vendors, or customer internal "&fI 	+ "development.  For a list of third party software vendors, call the "&uI 	+ "Sales Support-Team, at 1, 800, 8 3 2, 6 2 7 7. [+]If you choose to "&T> 	+ "write your own application, we recommend the [`]DECtalk "&F 	+ "[`]Application Development-Guide. The [`]DECtalk [`]Application "&H 	+ "Development-Guide provides a comprehensive understanding of Voice "&D 	+ "application issues.  Sample application software, intended to "&G 	+ "simplify development, is provided. The [`]DECtalk [`]Application "& B 	+ "Development-Guide may be ordered by calling the Educational "&? 	+ "Services Sales Support-Team, at 1, 800, 3 3 2, 5 6, 5 6.  "i  4   DECLARE	LONG	terminator_value, illegal_entry_count  	null_char$ = X'00'Ck 	terminator_value = 0% 	illegal_entry_count = 0%d  $ 	WHILE (input_key_buf(0) <> 0% OR  &* 				terminator_value <> DTK$K_TRM_TIMEOUT) 	!> 	! Keep getting commands from the user until the exit key "*",A 	! is entered, a wink is detected, or the timeout period expires. G 	! First, check if there are any keys in the typeahead buffer (done by bD 	! "get_key_string" with a 1 second timeout).  If so, process them. F 	! Otherwise, prompt the user for a command and wait for his response. 	!  GET_SHORT_READ: 	num_input_keys = 0% 	input_key_buf(0) = 0%F         stat% = get_key_string(null_char$, T1SECOND, terminator_value)  " 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENs
 		EXIT SUB 	END IFr) 	IF terminator_value = DTK$K_TRM_ASTERISKa 	THENu
 		EXIT SUB3 	ELSE	IF (terminator_value = DTK$K_TRM_NUMBER_SIGN)e 		THEN: 			GOSUB process_menu_entry	! Valid command so process it	) 			IF (input_key_buf(0) = DTK$K_TRM_ZERO)0 			THEN  				GO TO get_long_readg 			ELSEo 				GO TO get_short_read	 			END IFt7 		ELSE IF ((terminator_value <> DTK$K_TRM_TIMEOUT) OR	&u6 	        	 (terminator_value = DTK$K_TRM_TIMEOUT AND	& 				input_key_buf(0) = 0%))  			!: 			!  No keys in typeahead buffer so prompt for a command. 			! 		     THEN_/ 				CALL speak_text(DTK$K_WAIT, main_menu_msg$)s
 		     END IFf 	         END IF 	     END IF 	!A 	!  Any new keys received should be processed after the keys readIB 	!  from the typeahead buffer.  Start storing touch tone keys intoF 	!  into the buffer following the keys read from the typeahead buffer. 	!  GET_LONG_READ:s 	num_input_keys = 0%G         stat% = get_key_string(null_char$, T20SECOND, terminator_value)e  " 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENn
 		EXIT SUB 	END IFp) 	IF terminator_value = DTK$K_TRM_ASTERISKs 	THENd
 		EXIT SUB4 	ELSE	IF (terminator_value = DTK$K_TRM_TIMEOUT AND & 				input_key_buf(0) <> 0%)l 		THEN) 			CALL speak_all_text(msg_no_terminator)J: 			GOSUB process_menu_entry	! Valid command so process it	  6 		ELSE 	IF (terminator_value = DTK$K_TRM_TIMEOUT AND & 				input_key_buf(0) = 0%) 			THEN $ 				CALL speak_all_text(msg_timeout) 				EXIT SUB 			ELSEs 				GOSUB  process_menu_entry 	 			END IF  		END IF 	END IF     NEXTs	 	EXIT SUBn  PROCESS_MENU_ENTRY:  !?  !  Processes the touch tone key string received from the user.   ! 	IF num_input_keys > 1%o 	THEN  	!< 	!  Only single key commands are valid in this menu.  Inform< 	!  the user that an invalid command was entered and return. 	!& 		CALL speak_all_text(msg_bad_command)0 		illegal_entry_count = illegal_entry_count + 1% 	ELSE) 	    SELECT	input_key_buf(0)0 		CASE = 	DTK$K_TRM_ZERO			! Speak menu help msg* 			CALL speak_text(DTK$K_WAIT, main_menu$) 			illegal_entry_count = 0%k  ( 		CASE = 	DTK$K_TRM_ONE			! banking demo 			stat% = banking$ 			IF (stat% AND STS$M_SUCCESS) = 0% 			THEN, 				EXIT SUB	 			END IF* 			illegal_entry_count = 0%*  . 		CASE = 	DTK$K_TRM_TWO			! field service demo 			stat% = field_service$ 			IF (stat% AND STS$M_SUCCESS) = 0% 			THENf 				EXIT SUB	 			END IFm 			illegal_entry_count = 0%p  0 		CASE = 	DTK$K_TRM_THREE			! distribution demo	 			stat% = distribution $ 			IF (stat% AND STS$M_SUCCESS) = 0% 			THENi 				EXIT SUB	 			END IF  			illegal_entry_count = 0%*  ( 		CASE = 	DTK$K_TRM_FOUR			! labor entry 			stat% = labor_reporting			r$ 			IF (stat% AND STS$M_SUCCESS) = 0% 			THENT 				EXIT SUB	 			END IFt 			illegal_entry_count = 0%o  1 		CASE = 	DTK$K_TRM_FIVE			! dectalk product info * 			CALL speak_text(DTK$K_WAIT, dtcfamily$) 			illegal_entry_count = 0%   N  ! ---------------------------------------------------------------------------  !   options available:*J  !	this code can be put into the select code to give different menu items.  !!  !	Financial information section:   !  !		CASE = 	DTK$K_TRM_XXXX  !			stat% = financial_infoc&  !			IF (stat% AND STS$M_SUCCESS) = 0%	  !			THENe  !				EXIT SUB  !			END IF#  !			illegal_entry_count = 0%!  !H  !	---------------------------------------------------------------------  !	software support section:  !  !		CASE = 	DTK$K_TRM_XXXX<  !			stat% = DTK$SET_VOICE(voice_id, DTK$K_VOICE_DEEP_MALE,&  !						speaking_rate, &  !						comma_pause_duration,&  !						period_pause_duration)/  !			CALL speak_text(DTK$K_WAIT, soft_support$)M  !			illegal_entry_count = 0%I  !H  !	---------------------------------------------------------------------   !	information services section:  !  !		CASE = 	DTK$K_TRM_XXXX  !			stat% = info_services&  !			IF (stat% AND STS$M_SUCCESS) = 0%	  !			THEN1  !				EXIT SUB  !			END IF,  !			illegal_entry_count = 0%   !N  ! --------------------------------------------------------------------------- 		CASE ELSEO+ 			CALL speak_text(DTK$K_WAIT, msg_invalid)s1 			illegal_entry_count = illegal_entry_count + 1%R 	   END SELECT 	END IF0  !F  !  check status from menu fuctions -- If bad status (wink) exit menu.  !" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENN
 		EXIT SUB 	END IFc 	num_input_keys = 0%  !B  ! If user enters 3 illegal/incorrect commands, speak help message  ! 	IF illegal_entry_count >= 3 	THEN_) 		CALL speak_text(DTK$K_WAIT, main_menu$)p 		illegal_entry_count = 0% 	END IFd 	RETURNe    END SUB  M  !***************************************************************************oG  !  Load the user dictionary with the words and phonemic pronunciations G  !  stored in the sequential file specified in the foreign command lineoI  !  invoking the program.  Each line of this file contains the word to bemG  !  defined in the user dictionary followed by a space, followed by the I  !  phonemic pronunciation of the word.  The entry is parsed to find the oN  !  start and finnish of the word and it's replacement.  The word and phonemicM  !  pronunciation are loaded into the user dictionary. If the load dictionaryeN  !  command fails, the user is notified and processing is terminated.  ReturnsM  !  SUCCESS if the dictionary is loaded successfully or if no user dictionaryc<  !  file name is specified.  Otherwise, FAILURE is returned.     FUNCTION LONG load_dictionary()    %INCLUDE "DTKDEF"  ,   EXTERNAL LONG FUNCTION	DTK$LOAD_DICTIONARY&   EXTERNAL LONG CONSTANT	SS$_NORMAL, & 				DTK$_TOOLONG, DTK$_NOROOMa@   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min  0   COMMON (application_specific)	LONG	voice_id, & 					num_hold_keys, &e 					num_input_keys, & 				BYTE	hold_key_buf(80), & 					input_key_buf(80), &e$ 				STRING	dictionary_file_name = 80  / 	MAP (dictionary) STRING dictionary_entry = 256D( 	DECLARE STRING		diction_word,  phonetic% 	DECLARE LONG		word_count, phonem_endm  
 	sp$ = X'20'CD 	tab$ = X'09'C  	null_char$ = X'00'C, 	ON ERROR GOTO ERROR_CHECKG 	IF LEFT$(dictionary_file_name,1) = null_char$	! No dictionary filenameu 	THEN 6 	  !  No dictionary was specified in the command line.# 	  !  Return to initialize_dectalk u 		load_dictionary = 1% 		exit functionn 	END IF"  A 	OPEN dictionary_file_name AS FILE #1,	ORGANIZATION SEQUENTIAL, &o! 						ACCESS READ, MAP DICTIONARYm 	!E 	! Since there is no timeout associated with the DTK$LOAD_DICTIONARY cC 	! command, it is possible for an application to hang waiting for anF 	! response after issuing the DTK$LOAD_DICTIONARY command.  Therefore,G 	! arm a watchdog timer (6 minutes in this case) to time the loading ofoG 	! the entire user dictionary.  If all the entries are not loaded into eA 	! the user dictionary before the timer expires, then assume thate7 	! something is wrong with the DECtalk module and exit., 	!: 	CALL set_timer(time_6_min)		! Set system (watchdog) timer        WHILE 1% = 1% 	GET #1E 	!  3 	!  Read in all of the words and substitutions froma8 	!  the sequential file specified in the command string. 	!+ 	word_count = POS(dictionary_entry, sp$, 1)t 	IF word_count = 0%p2 	THEN		word_count = POS(dictionary_entry, tab$, 1) 	END IF 2 	phonem_end = POS(dictionary_entry, null_char$, 1)  7 	diction_word =	SEG$(dictionary_entry, 1, word_count-1) > 	phonetic =	SEG$(dictionary_entry, word_count+1, phonem_end-1)  > 	stat% = DTK$LOAD_DICTIONARY(voice_id, DICTION_WORD, phonetic)1 	IF (stat% = DTK$_TOOLONG OR stat% = DTK$_NOROOM)l 	THENc 	     !d9 	     !  These are not generally fatal errors.  However, l: 	     !  they will be treated as such.  In creating a demo9 	     !  program, if words cannot be loaded into the userd> 	     !  dictionary, the programmer should be notified so that@ 	     !  the appropriate action can be taken.  By treating these? 	     !  errors as fatal, the programmer will at least know thei7 	     !  point in the program where the error occurred.s 	     !G
 		CLOSE #1 		CALL error_log(stat%)  		load_dictionary = 0%' 		EXIT FUNCTION			! Fatal error so exit,/ 	ELSE IF (stat% <> SS$_NORMAL) 	! Fatal failureS
 	     THEN- 			CALL cancel_timer		! Cancel watchdog timert 			CLOSE #1K 			CALL error_log(stat%)6 			CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit 	     END IF 	END IFS	      NEXTm  	!n7 	!  Entire dictionary is loaded so cancel system timer.0 	!  DONE:4 	CALL cancel_timer			! Cancel system(watchdog) timer$ 	CLOSE #1				! Close dictionary file 	load_dictionary = 1%r  EXIT FUNCTION  
  ERROR_CHECK:u( 	IF ERR = 11%		! IF End of File is found 	THENT
 		RESUME DONEu 	ELSEu 	   CALL error_log(VMSSTATUS)y 	   RESUME HEREf HERE:p 	   load_dictionary = 0% 	   EXIT FUNCTION	 	END IFk
  END FUNCTIONT  M  !***************************************************************************eH  !  DECtalk stopped speaking because it was in autostop keypad mode whenG  !  it received a Touch Tone Key from the user.  First, send DECtalk a oK  !  right square bracket "]" just in case speech was stopped while speakingiM  !  phonemic text. Then, restart speech (using DTK$SET_SPEECH_MODE) and resetr6  !  the speaking voice and rate (using DTK$SET_VOICE).  !  SUB restart()    %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT	STS$M_SUCCESS/   EXTERNAL LONG FUNCTION	DTK$SET_SPEECH_MODE, &A 				DTK$SET_VOICE_  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_mineI   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, &e# 		 period_pause_duration, speech_on_-   COMMON (application_specific)	LONG	voice_idt      rsbracket$    = "]"  6   DECLARE LONG old_mode				! Current mode before reset  ) 	CALL speak_text( DTK$K_WAIT, rsbracket$)P 	! 	!  Set speakig on 	! 	CALL set_timer(Time_45_sec); 	stat% = DTK$SET_SPEECH_MODE(voice_id, speech_on, old_mode)  	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN. 		CALL error_log(stat%)a5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitL 	END IFl 	!% 	!  Reset the voice and speaking raten 	CALL set_timer(Time_45_sec)8 	stat% = DTK$SET_VOICE(voice_id, voice, speaking_rate, &0 				comma_pause_duration, period_pause_duration) 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN= 		CALL error_log(stat%)n5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitE 	END IF     END SUB  M  !***************************************************************************	E  !  End the current user session.  Since the DTK$HANGUP_PHONE commandSC  !  does not set a timeout, and it requests DECtalk to send a phoneuG  !  status, a watchdog timer is set to insure that the application doesdG  !  not hang (if DECtalk fails).  If a longer timeout period is needed,BH  !  adjust the value of the parameter moved into SET_TIMER_STRING beforeM  !  performing "set_timer".  After the watchdog timer is set, speak a goodbye*I  !  message to the caller and then hangup the phone.  The goodbye messagenB  !  spoken can be changed by modifying the text in "msg_goodbye".   !  SUB end_call ()  )   EXTERNAL LONG CONSTANT	STS$M_SUCCESS, &  				SS$_TIMEOUT, & 				DTK$_ONHOOKo  -   EXTERNAL LONG FUNCTION 	DTK$HANGUP_PHONE, &( 				DTK$READ_KEYSTROKE  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_minn-   COMMON (application_specific)	LONG	voice_id_  G   msg_goodbye$  = "Thank you for calling the DECtalk-demonstration.  "&	@ 		+ "For more information, please call 1, 800, 8 3 2, 6 2 7 7. "  : 	CALL set_timer(time_6_min)		! Set system (watchdog) timer 	!$ 	!  Say goodbye and hangup the phone 	!1 	stat% = DTK$HANGUP_PHONE(voice_id, msg_goodbye$)-* 	CALL cancel_timer			! Cancel system timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENn 		CALL error_log(stat%)e5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitc 	END IF! 	!. 	!  workaround to clear the internal WINK flag 	! 	timeout% = 1% 	WHILE 1% = 1%? 	    CALL set_timer(time_45_sec)		! Set system (watchdog) timerl: 	    stat% = DTK$READ_KEYSTROKE(voice_id, xx%, , timeout%). 	    CALL cancel_timer			! Cancel system timer  6 	    IF (stat% = DTK$_ONHOOK) OR (stat% = SS$_TIMEOUT)	 	    THENS6 		CALL set_timer(time_45_sec)		! Set system (watchdog)7 		stat% = DTK$READ_KEYSTROKE(voice_id, xx%, , timeout%)i+ 		CALL cancel_timer			! Cancel system timerK  # 		IF (stat% AND STS$M_SUCCESS) = 0%t 		THEN 		    CALL error_log(stat%)-9 		    CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exiti 		END IF 		EXIT SUB		  + 	    ELSE IF (stat% AND STS$M_SUCCESS) = 0%% 		 THENe 		    CALL error_log(stat%)S9 		    CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit 	 		 END IFl 	    END IF= 	NEXT!    END SUB  J  !  ----------------------------------------------------------------------J  !  Speak all text -- disable autostop keypad, speak text in prompt using :  !  "speak_text". If autostop was set, re-enable autostop.  !#  SUB speak_all_text (STRING prompt)a    %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT	STS$M_SUCCESS,   EXTERNAL LONG FUNCTION	DTK$SET_KEYPAD_MODE  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, &nP         period_pause_duration, speech_on, new_mode, number_of_rings, keypad_mode-   COMMON (application_specific)	LONG	voice_id*     DECLARE LONG	keypad_on     keypad_on = DTK$K_KEYPAD_ONo 	!F 	!  If autostop keypad mode is enabled (keymode = DTK$K_KEYPAD_AUTO), 1 	!  then enable the keypad without autostop mode.o 	!C 	IF (keypad_mode = DTK$K_KEYPAD_AUTO)	! Keypad is in autostop mode	e 	THENi7 		CALL set_timer(Time_45_sec)	! Set the watchdog timer	m2 		stat% = DTK$SET_KEYPAD_MODE(voice_id, keypad_on)1 		CALL cancel_timer		! Cancel the watchdog timer	 # 		IF (stat% AND STS$M_SUCCESS) = 0%m 		THEN 			CALL error_log(stat%)  			CALL LIB$STOP(stat% BY VALUE) 		END IF 	END IF   ( 	!  Send text to DECtalk to be spoken.  = 	!  Specify the mode as DTK$K_WAIT so that text is completelys< 	!  spoken before the keypad is re-enabled in autostop mode.  $ 	CALL speak_text(DTK$K_WAIT, prompt)  ' 	!  If autostop keypad mode was enabled 9 	!  (keypad_mode = DTK$K_KEYPAD_AUTO), then re-enable it.I 	!D 	IF (keypad_mode = DTK$K_KEYPAD_AUTO) ! Keypad was in autostop mode	 	THEN 4 		CALL set_timer(Time_45_sec)	! Set watchdog timer		4 		stat% = DTK$SET_KEYPAD_MODE(voice_id, keypad_mode)1 		CALL cancel_timer		! Cancel the watchdog timer	y# 		IF (stat% AND STS$M_SUCCESS) = 0%	 		THEN 			CALL error_log(stat%)  			CALL LIB$STOP(stat% BY VALUE) 		END IF 	END IFI  END SUB  M  !***************************************************************************o.  !  Sends the prompt (specified by prompt) to 1  !  the DECtalk to be spoken.  Returns SUCCESS ifE>  !  everything is spoken o.k.  Otherwise, FAILURE is returned.  !  7  !  NOTE:  If DTK$SPEAK_TEXT is called with mode set toc8  !	   DTK$K_WAIT or DTK$K_STATUS, a phone status requestA  !	   is sent from DECtalk.  Since there is no timeout associatedl>  !	   with this request, a system timer should be set (to someG  !	   exteremely long value (16 minutes) to insure that the applicationD  !	   does not hang.  !8  SUB speak_text (LONG return_status_mode, STRING prompt)    %INCLUDE "DTKDEF"  )   EXTERNAL LONG CONSTANT	STS$M_SUCCESS, &  				SS$_NORMAL'   EXTERNAL LONG FUNCTION	DTK$SPEAK_TEXTs  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_mine  -   COMMON (application_specific)	LONG	voice_id  	! 	!  Speak the text: 	CALL set_timer(time_16_min)	! Set system (watchdog) timer= 	stat% = DTK$SPEAK_TEXT(voice_id, prompt, return_status_mode)h) 	CALL cancel_timer		! Cancel system timer  	IF (stat% <> SS$_NORMAL)e 	THENa 		CALL error_log(stat%)!5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit  	END IF_  END SUB  I  ! **********************************************************************i/  !	Log error to the operator console  "OPER11".   !N  !  Take the error number, input to SYS$GETMSG to get the system message text.P  !  Format the message text with the specific terminal line for that applicationL  !  "process" (using SYS$FAO), and call SYS$SENOPR with the error structure.  !H  !  NOTE:  the DTK$ errors that occur will have the %DTK- facility name,B  !	  but not the error message text, just the error number.  It isG  !	  anticipated that these messages will be included in future VMS/RTLn  !	  releases.  !!  SUB error_log(LONG error_number)d  B  %INCLUDE "$OPCDEF" %FROM %LIBRARY "SYS$LIBRARY:BASIC$STARLET.TLB"  #   EXTERNAL LONG CONSTANT	SS$_NORMALt#   EXTERNAL LONG FUNCTION	SYS$FAO, &  				SYS$SNDOPR, &t 				SYS$GETMSG  0   COMMON (application_specific)	LONG	voice_id, & 					num_hold_keys, &  					num_input_keys, & 				BYTE	hold_key_buf(80) , &  					input_key_buf(80), &>' 				STRING	dictionary_file_name = 80, &N 					terminal_line  B   MAP	(error_struct) LONG opc$type_target, LONG OPC$L_MS_RQSTID, & 			STRING error_text = 120+   MAP	(error_struct) STRING error_msg = 128D%   MAP   (temp)  STRING error_buf = 80i  +   DECLARE STRING CONSTANT filler = "  ON  "D3   DECLARE STRING CONSTANT control_str = "!AD!AS!AD"t   DECLARE LONG buf_len  Q      temp% = SYS$GETMSG(error_number by value, buf_len, error_buf, 15% by value,)   !A  ! Set message target to OPER11, and the message type to RQ_RQST.AD  ! For more information on sending messages to an operators terminal"  ! see the System Services manual.  !>     opc$type_target = (OPC$M_NM_OPER11 * 256%) OR OPC$_RQ_RQST  6  	temp% = SYS$FAO(control_str, buf_len, error_text,		&*  				buf_len by value, error_buf by ref,	&/  				filler, 5% by value, terminal_line by ref)r2  	WHILE MID$(error_text, buf_len + 1, 1) <> X"00"C,  		MID$(error_text, buf_len + 1, 1) = X"00"C  		buf_len = buf_len + 1  	NEXT,  	stat% = SYS$SNDOPR(error_msg, 0% by value)3   	IF (stat% <> SS$_NORMAL)		! Send to oper failed	T  	THEN5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitL	  	END IF A  END SUB  M  !*************************************************************************** J  !  Sets the system (watchdog) timer to expire "sec" seconds in the futureI  !  by invoking the "SYS$SETIMR" system service.  SYS$BINTIM is passed a eL  !  character string in the format "D HH:MM:SS", where D is Days, H is HoursH  !  M is minutes etc.  The output of BINTIM is the quadword delta_time ,/  !  which gets passed as input to SYS$SETIMR.  T  !"  SUB set_timer(STRING time_string)  ( 	EXTERNAL LONG CONSTANT	STS$M_SUCCESS, & 				SS$_TIMEOUTE% 	EXTERNAL LONG FUNCTION	SYS$SETIMR, &  				SYS$BINTIM: 	EXTERNAL LONG		LIB$SIGNAL 	! Indicate exception condition% 	MAP (quadword) LONG delta_time, FILL	  , 	stat% = SYS$BINTIM(time_string, delta_time)# 	IF (stat% AND STS$M_SUCCESS)  = 0%e 	THEN( 		CALL error_log(stat%)K5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit_ 	END IFa  K 	stat%= SYS$SETIMR( ,delta_time, LIB$SIGNAL BY VALUE, SS$_TIMEOUT BY VALUE) # 	IF (stat% AND STS$M_SUCCESS)  = 0%n 	THENL 		CALL error_log(stat%)	5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exity 	END IFe  END SUB  J  !  ----------------------------------------------------------------------$  !  Cancel the system watchdog timer  !  SUB cancel_timer()c  %  EXTERNAL LONG CONSTANT	STS$M_SUCCESSS?  EXTERNAL LONG FUNCTION	SYS$CANTIM		! Cancel SYS$SETIMR requestN  6 	stat% = SYS$CANTIM(SS$_TIMEOUT BY VALUE, 0% BY VALUE)" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENt 		CALL error_log(stat%)i5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exiti 	END IFs  END SUB