C 	%TITLE "DECTALK-DEMO.BAS  --  BASIC APPLICATION GUIDELINE PROGRAM"   !  !			  BASIC_DTDEMO.BAS   !  7  !	NOTE:  This program was written with VAX BASIC V3.0.   !E  !  The following file contains a "modifiable" demonstration program  F  !  to be included in the DECtalk Application Development Guide.  ThisF  !  demonstration program typifies most telephone application programsI  !  written for DECtalk.  It is written in VAX BASIC and uses Version 4.5 G  !  or later of the VMS/MicroVMS Run-Time Library Support provided for    !  DECtalk.  !B  ! Description:	This program provides a framework to develop other6  !		demonstration programs.  Currently, it provides an8  !		information services demonstration giving the Boston5  !		weather forecast, transportation information, ski 9  !		conditions, and mortgage rate information in a single ;  !		menu system.  The program provides dial-in access only. @  !		When a user calls in, DECtalk answers the phone and speaks aA  !		short greeting message.  Then, the customer is asked to enter 9  !		his access code and password.  The customer is given  6  !		three attempts to enter his access code and three 8  !		attempts to enter his password.  Once access to the 7  !		system has been gained, DECtalk prompts the user to =  !		enter a command.  The six valid commands are given below:   !-  !		   Key 1 for the Boston weather forecast. ,  !		   Key 2 for transportation information.+  !		   Key 3 for mortgage rate information. ,  !		   Key 4 for the current ski conditions.  !		   Key 0 for help.  !		   Key * to exit.   !  :  !	NOTE:	the user's access code, password and all commands9  !		except exit must be terminated by the pound sign key, :  !		although the application will accept input without the=  !		pound sign key after a timeout.  When a valid command is  @  !		entered, DECtalk speaks the appropriate message to the user.?  !		Once the exit key is entered, a wink is detected, or a user ?  !		fails to enter a command in the specified time period, the  ?  !		user session is ended.  DECtalk speaks a goodbye message to :  !		the user and hangs up the telephone.  Then, DECtalk isA  !		re-enabled for autoanswer and waits for a new telephone call.   !@  !		All error messages are logged only to the operator terminals>  !		that have specified that the "OPER11" type of message will>  !		be handled. These messages give the error message, and the;  !		terminal line connected to that process.  To have error C  !		messages logged to the console terminal, or any other terminal, :  !		at the DCL prompt ($), enter the REPLY/ENABLE command:  !  !			$ reply/enable=oper11  !A  !		To enter this command, you must have the OPER user privelege.   !F  !  VMS VERSION 4.5 RUN-TIME LIBRARY RESTRICTIONS FOR DECtalk SUPPORT:  !<  !	There is a problem with the DTKDEF module in STARLET.OLB.F  !	The definitions of the touch tone key constants DTK$K_TRM_ZERO thruB  !	DTK$K_TRM_NINE should be set to the ASCII valies of the digits.F  !	The correct definitions are currently found in "dtkdef.bas".  Note,G  !	it is anticipated that this will be fixed in the Version 4.6 release 6  !	of VMS.  Consult the release notes for Version 4.6.  !E  !	The current version of the RTL does not provide a command to check E  !	the status of DECtalk.  With this command, an application program  D  !	can determine whether or not the DECtalk module has power cycled G  !	since the last time its status has been observed.  If it is detected F  !	that the DECtalk module has power cycled, the application specific I  !	parameters (speaking voice, speaking rate, words loaded into the user  K  !	loadable dictionary) should be reinitialized.  By periodically checking  C  !	the status of the DECtalk module, and reinitializing if the unit A  !	has power cycled, an application may not have to be terminated G  !	to replace failed DECtalk modules.  An alternative solution (used in C  !	this demonstration program) re-initializes application specific  J  !	parameters every time a phone call has not been received in 15 minutes.  !I  !	Most of the DTK$ RTL functions that read and return a status condition G  !	from the DECtalk do not have a timeout specified on their read from  ?  !	DECtalk.  These DTK$ RTL functions include DTK$HANGUP_PHONE, D  !	DTK$LOAD_DICTIONARY, DTK$RETURN_LAST_INDEX, DTK$SET_KEYPAD_MODE, F  !	DTK$SPEAK_FILE, DTK$SPEAK_PHONEMIC_TEXT, DTK$SPEAK_TEXT.  Without aF  !	timeout, it is possible for the application program to hang if the J  !	DECtalk module fails, the power cord is disconnected or the RS232 cableC  !	is disconnected. To prevent the application program from hanging A  !	without notifying the operator of the problem, a system timer  G  !	(using SYS$SETIMR) is set before ALL calls made to the DTK$ facility C  !	of the Run-Time Library.  This is done by performing the routine I  !	SET_TIMER.  If a response is received from the DECtalk within the time G  !	period specified, the system timer is canceled (using SYS$CANTIM) by H  !	performing the routine CANCEL_TIMER. Otherwise, if the timer expires,H  !	the timeout value 556 will be returned. To correct any error that mayI  !	occur in the communication between the DECtalk module and the physical I  !	device, terminate the current job, correct the error, and then restart F  !	the job.  Note, the application program will hang until the problem  !	has been corrected.  !F  !	The current version of DTK$READ_STRING does not work correctly.  IfF  !	a series of touch tone keys is entered on the touch tone keypad andH  !	a terminating character (number sign key or asterisk) is not entered,F  !	the series of touch tone keys entered is returned after the timeoutF  !	period specified along with a terminator code of DTK$K_TRM_TIMEOUT.E  !	On the next call to DTK$READ_STRING, when the series of touch tone H  !	keys is returned, it always includes the last touch tone key returnedI  !	in the previous call to DTK$READ_STRING as the first touch tone key in =  !	the series of keys returned.  The routine "GET_KEY_STRING" F  !	in this demonstration program can be used to read a series of touchG  !	tone keys terminated by the number sign key or the asterisk key.  It >  !	is similar in functionality to the DTK$READ_STRING routine.  !    %INCLUDE "DTKDEF"  (  EXTERNAL LONG CONSTANT	STS$M_SUCCESS, & 			SS$_NORMAL,   & 			SS$_TIMEOUT  !8  !  EXTERNAL Run-time Library Routines (DECtalk support)  !  EXTERNAL LONG FUNCTION & 0 			DTK$ANSWER_PHONE,	! Wait for phone to ring !&2 			DTK$INITIALIZE, 	! Initialize DECtalk device !&3 			DTK$TERMINATE, 		! End initialized DECtalk use!&  			initialize_dectalk, & 			verify_user  !  !  Prompts and demo text   !0   COMMON (MESSAGE_TEXT) STRING  rsbracket = 1, & 				msg_welcome  = 60,&  				msg_access   = 100, &  				msg_password = 100, &  				msg_invalid  = 40, & 				msg_bad_command   = 40, &  				msg_no_terminator  = 100, &  				msg_noaccess = 100, &  				msg_goodbye  = 100, &  				msg_timeout  = 50, & 				menu_prompt  = 100, &  				msg_help     = 320, &  				msg_weather  = 475, &  				msg_MBTA     = 365, &  				msg_mortgage = 500, &  				msg_ski      = 770      rsbracket    = "]" N    msg_welcome  = "Welcome to the DECtalk information services demonstration."N    msg_access   = "Please enter your access code followed by the pound-key." &* 		+ " You may enter any number as a test."J    msg_password = "Please enter your password followed by the pound-key."&* 		+ " You may enter any number as a test."6    msg_invalid  = "Invalid entry.  Please try again. "F    msg_noaccess = "Access denied.  Please check your access code and"& 		+ " password and try again."B    msg_goodbye  = "Thank you for calling the DECtalk application"&/ 		+ " demonstration program.  Have a nice day." C    msg_timeout  = "No key pressed in the timeout period specified." <    msg_bad_command  = "Invalid command.  Please try again. "I    msg_no_terminator= "Please remember to terminate your entry with the"& % 		+ "pound-key.  Command accepted.  "   L    menu_prompt  = "Please enter a command.  For help, press 0 followed by "&1 		+ "the pound-key. To exit, press the star-key."   K    msg_help     = "To hear the current Boston weather forecast, Press 1. "& 4 		+ "To hear transportation information, Press 2. "&3 		+ "To hear mortgage rate information, Press 3. "&w4 		+ "To hear the current ski conditions, Press 4. "&7 		+ "To repeat this message, Press 0. Terminate your "&m> 		+ "entry with the pound-key.  To exit, Press the star-key. "  L    msg_weather  = "Welcome to the Boston Area Weather Service. April 1st. "&; 		+ 'Today will be a day ["]more like early May.  Current'&mA 		+ " downtown Boston temperature is 58 degrees fahrenheit, 14 "&	@ 		+ 'Celsius. It will be a ["]beautiful sunny day, breezy and '&A 		+ "mild, with a high of 76 degrees Fahrenheit. Humidity will "&dA 		+ "be 76%.  Barometric pressure is currently 32.5.  Tomorrow "&n= 		+ "will be cooler, with a high of fifty on the coast and "&o; 		+ "sixty inland.  Fair weather is expected to continue "&n 		+ "throughout the week. "e  N    msg_MBTA     = "Welcome to the MBTA Information Line.  All MBTA lines are"&; 		+ " on time.  The B and M line from the North Shore is "& ; 		+ "running a limited service, with trains running from "&e? 		+ "Ipswich and Rockport, at 8 A.M. and 9 A.M. only.  There "& ; 		+ "will be no red line service between Park Street and "&m: 		+ "Harvard, Monday from 9 P.M. to 1 A.M..  Substitute "&+ 		+ "bus transportation will be provided. "e  N    msg_mortgage = "Welcome to Hamden National Bank's Mortgage Line.  All of "&B 		+ "the following rates are subject to change.  The application"&< 		+ " fee is $250. 30 year rate with 10% [']down are 9.9% "&> 		+ "with 3 [aen ax] half points, 10.2% with 3 points, 10.5%"&? 		+ " with 2 [aen ax] half points, 10.8% with no points.  15 "&!< 		+ "year rates with 10% [']down are 9.9% with 2 [aen ax] "&; 		+ "half points, 10.1% with 2 points, and 10.5% with no "&!> 		+ "points. Adjustable rates are at 8.5% fixed for 3 years "&5 		+ "with 2% a year and 6% lifetime caps thereafter."r  P    msg_ski      = "Welcome to the New England Ski Report. January 31st. Skiing"&@ 		+ " is excellent in Vermont because of yesterday's snowfall "&= 		+ "of 10 inches. All ski trails are open at Stowe, Sugar-"&lA 		+ "bush, Mt. Snow, Stratton, Jay Peak, and Smuggler's Notch, "& @ 		+ "with packed powder and full snow-making in operation. All"&? 		+ " cross country ski trails are also open, with many groom"&n@ 		+ "ed trails.  Skiing in Maine and [nuw] Hampshire is good, "&A 		+ "with cold temperatures allowing for constant snow-making. "&e@ 		+ "Gun-stock has 15 [aatax] 25 trails open, Mt. Cranmore has"&@ 		+ " 15 [aatax] 20 trails open, Attitash and Wildcat have all"&@ 		+ " trails open.  Sugar-loaf and Sunday River also have all "&; 		+ "trails open, with packed powder and loose granular. "&S= 		+ "Expected snowfall in Maine and [nuw] Hampshire should "&t% 		+ "improve weekend ski conditions."e  P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &7 		     LONG	MAX_ENTRY, T1SECOND, T2SECOND, T20SECOND, &c# 					T30SECOND, T5MINUTE, T15MINUTEd  I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, & P         period_pause_duration, speech_on, new_mode, number_of_rings, keypad_mode  1   COMMON (application_specific)	LONG		voice_id, &c 						num_hold_keys, & 						num_input_keys, &  					BYTE	hold_key_buf(80) , & 						input_key_buf(80), &( 					STRING	dictionary_file_name = 80, & 						terminal_linel 	MAX_ENTRY = 3
 	T1SECOND = 1s
 	T2SECOND = 2s 	T20SECOND = 20a 	T30SECOND = 30u 	T5MINUTE = 300e 	T15MINUTE = 900 	TIME_45_SEC = "0 00:00:45"e 	TIME_90_SEC = "0 00:01:30"o 	TIME_6_MIN  = "0 00:06:00"! 	TIME_16_MIN = "0 00:16:00"b 	voice = DTK$K_VOICE_MALEi 	speaking_rate = 180 	comma_pause_duration = 0d 	period_pause_duration = 0 	speech_on = DTK$K_SPEAK 	new_mode = DTK$M_SQUARE  	keypad_mode = DTK$K_KEYPAD_AUTO  %page  ! maina  -  DECLARE LONG	version, init_dtk, need_to_init!  init_dtk = 0%  need_to_init = 0% 	!A 	! Get the name of the physical device that the DECtalk module isaB 	! connected to and the name of the dictionary file (if specified)A 	! that contains DECtalk's user dictionary words. If the call to  - 	! DTK$INITIALIZE is unsuccessful, then exit.r 	!9 	CALL get_cli_params(terminal_line, dictionary_file_name)P   	call set_timer(Time_45_sec)9 	stat% = DTK$INITIALIZE(voice_id, terminal_line, version)F 	call cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENm 		CALL error_log(stat%)t5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitl 	END IFt    WHILE_LOOP: 	WHILE 1% = 1%			! do always   	num_hold_keys = 0%  	num_input_keys = 0%  9 	 !  Check to see if the DECtalk needs to be initialized. < 	 !  (init_dtk = need_to_init = 0).  If so, reinitialize theC  	 !  application specific parameters.  Then, set a watchdog timer aB 	 !  for 16 minutes in the future in case the DECtalk module fails@ 	 !  and no response to the DTK$ANSWER_PHONE command is received> 	 !  from DECtalk.  ** NOTE:  MAKE SURE THE WATCHDOG TIMER IS : 	 !  ALWAYS SET TO A VALUE LARGER THAN THE TIMEOUT PERIOD C 	 !  SPECIFIED IN THE DTK$ANSWER_PHONE COMMAND.  THE WATCHDOG TIMER / 	 !  CAN BE LARGER THAN 16 MINUTES.  Next, waitwB 	 !  for the phone connected to the DECtalk to ring.  If the phone? 	 !  does not ring in "timeout" seconds (or the watchdog timer tB 	 !  times out), normally, the status of the DECtalk unit would beA 	 !  checked.  This is not possible in the current version (V4.5)wA 	 !  of the VMS Run-Time Library Support for DECtalk.  Therefore,eH 	 !  instead of reinitializing DECtalk every time the unit power cycled,C 	 !  it is reinitialized every time no phone calls are received in eG 	 !  "timeout" seconds. Then, a greeting message is spoken to the user.e
          ! 	IF init_dtk = need_to_initl@ 	THEN  stat% = initialize_dectalk		! Reinitialize DECtalk paramS# 		IF (STAT% AND STS$M_SUCCESS) = 0%t 		THEN- 			!  Initialization failed.  It appears thatR0 			!  the DECtalk module may be dead.  For now,  			!  I will exit.    			GO TO out			! End the program 		END IF9 	    init_dtk = NOT need_to_init			! Appl. init. completeu 	END IFn; 	CALL set_timer(time_16_min)		! Set system (watchdog) timer  	!G 	! The greeting message DECtalk speaks upon answering the telephone can%; 	! be modified by changing the text in the character string A 	! "msg_welcome". The number of rings DECtalk waits to answer therF 	! telephone ("number_of_rings"), can be changed but it is recommended7 	! that the phone is always answered on the first ring., 	!J         stat% = DTK$ANSWER_PHONE(voice_id, number_of_rings, msg_welcome, & 								T15MINUTE) 	CALL cancel_timer 	IF (stat% = SS$_NORMAL) 	THENo 		! A 		!  The telephone has been answered. Then verify that the callercA 		!  is a valid user of the system.  If the caller fails to enter B 		!  a valid access code and password in three attempts, access toA 		!  system is denied.  If the user is successful, prompt him fory 		!  a command.	 		!iA 		!  NOTE: DTK$ANSWER_PHONE automatically enables autostop keypad 6 		!	 mode, and wink detection on the telephone keypad. 		!	8 		IF (stat% = verify_user) = 0%	! Deny access and hangup 		THEN. 		   CALL speak_text(DTK$K_WAIT, msg_noaccess) 		   CALL end_call	  s	 		ELSE			i 			!; 			! The user has successfully gained access to the system.t9 			! Start processing commands from the user.  Note, the "8 			! menu prompt spoken prior to receiving commands from: 			! the user, can be modified by changing the text in the# 			! character string "menu_prompt"  			! 			CALL menu 			CALL end_call 		END IF9 	ELSE IF (stat% = SS$_TIMEOUT)			! Timeout period expiredd
 	     THEN2 		init_dtk = need_to_init			! Have to reinitialize
 	     ELSE 		CALL error_log(stat%)t5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit  	     END IF 	END IFo     NEXT  c out:A     !  some fatal error has occured... Terminate DECtalk and exit      !_     CALL set_timer(Time_45_sec)eC     stat% = DTK$TERMINATE(VOICE_ID)     ! End use of DECtalk device      CALL cancel_timerP%     IF (stat% AND STS$M_SUCCESS) = 0%      THEN 		CALL error_log(stat%)y
     END IF  s  END  N  !********************* END OF PROGRAM ***************************************  !C  ! Gets the parameters from the command line using LIB$GET_FOREIGN.eC  ! If a fatal error occurs, it is reported and the demo is stopped.sK  ! Otherwise, the parameters specified are returned in terminal_line_stringoP  ! for the device name, and dictionary_name for the name of the dictionary file.  !A  SUB  get_cli_params (STRING device_name, STRING dictionary_name)	  % 	EXTERNAL LONG CONSTANT STS$M_SUCCESS ' 	EXTERNAL LONG FUNCTION LIB$GET_FOREIGNN   	DECLARE STRING get_param_buf*0 	DECLARE LONG device_length, diction_name_length  * 	stat% = LIB$GET_FOREIGN(get_param_buf,,,)" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENd 		CALL error_log(stat%)!5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitr 	END IFe+ 	device_length = POS(get_param_buf, " ", 1)a) 	diction_name_length = LEN(get_param_buf).   	IF device_length = 0% 	THENG: 		device_name = SEG$(get_param_buf,1, diction_name_length) 	ELSET9 		device_name = SEG$(get_param_buf, 1, device_length - 1)t9 		dictionary_name = SEG$(get_param_buf, device_length+1,&  						 diction_name_length)b 	END IF 	   END SUBl    K  !*************************************************************************r?  !  Initializes the application specific parameters of DECtalk.,D  !  First, left square bracket ('[') and right square bracket (']') M  !  are enabled as phonemic delimiters. To specify other modes, the bit masks M  !  for the modes to be set should be OR'd together with the DTK$M_SQUARE bitmM  !  mask and assigned to the varible "NEW_MODE".  Next, the default speaking eH  !  voice and speaking rate are selected for the application.  The commaE  !  pause and period pause are set to DECtalk defaults.  Other voicestI  !  can selected for the default speaking voice by modifying the variable	B  !  "voice".  Likewise, a different speaking rate can be specifiedG  !  by changing the static variable "speaking_rate".  Finally, the useriF  !  dictionary is loaded (by invoking "load_dictionary").  Note, otherF  !  application specific parameters should also be initialized in this"  !  subroutine if the need arises.  !  #  FUNCTION LONG initialize_dectalk()   &   EXTERNAL LONG CONSTANT	STS$M_SUCCESS(   EXTERNAL LONG FUNCTION	DTK$SET_MODE, & 				DTK$SET_VOICE, & 				load_dictionary.  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min	  I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, &l- 		 period_pause_duration, speech_on, new_modet-   COMMON (application_specific)	LONG	voice_ids   	CALL set_timer(Time_45_sec)+ 	stat% = DTK$SET_MODE(voice_id, new_mode, )t 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENu 		CALL error_log(stat%)w5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitl 	END IF  	!A 	!  Indicate the type of voice and the speaking rate for DECtalk.i 	CALL set_timer(Time_45_sec)7 	stat% = DTK$SET_VOICE(voice_id, voice, speaking_rate &i1 				,comma_pause_duration, period_pause_duration)s 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN] 		CALL error_log(stat%) 5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exita 	END IF  	!8 	! load user dictionary using "load_dictionary" function 	!% 	initialize_dectalk = load_dictionarya 	EXIT FUNCTION
  END FUNCTION   K  !  -----------------------------------------------------------------------N  !;  !  Verifies that the caller is a valid user of the system.NG  !  The caller is given three attempts to enter a valid access code and G  !  three attempts to enter his password.  If the caller fails to entersL  !  a valid access code or a valid password in the timeout period specified,4  !  FALSE is returned.  Otherwise, TRUE is returned.  !F  !  NOTE: In this demonstration, almost all access codes and passwords>  !	 are detected as valid.  The only ways an access code or a B  !	 password are rejected are if the user fails to enter an accessC  !	 code or a password in the time period specified, or if the user B  !	 terminates his access code or password with the star key ("*")J  !	 rather than the pound key ("#").  All valid access codes and passwordsH  !	 (terminated with the pound key) are verified by performing the dummy@  !	 verification routines "access_verify" and "password_verify"..  !	 Both of these routines always return TRUE.    FUNCTION LONG verify_user()    %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT STS$M_SUCCESS  0   COMMON (MESSAGE_TEXT) STRING  rsbracket = 1, & 				msg_welcome  = 60,&E 				msg_access   = 100, &t 				msg_password = 100, &i 				msg_invalid  = 40, & 				msg_bad_command   = 40, &u 				msg_no_terminator  = 100, &  				msg_noaccess = 100  P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &A 		     LONG   MAX_ENTRY, T1SECOND, T2SECOND, T20SECOND, T30SECONDo  *   EXTERNAL LONG FUNCTION	get_key_string, & 				access_verify, & 				password_verify   >   DECLARE LONG illegal_entry,			! Number of illegal entries! &* 		term_code			! Key string terminator code  + 	illegal_entry = 0%			! No bad attempts yet_  check_user_loop:p#     WHILE illegal_entry < MAX_ENTRYt 	num_input_keys = 0% 	!E 	! Gets the user's access code entered on the touch tone keypad.  TheeI 	! entered access code is returned in the character buffer "access_code". G 	! Currently, the maximum size of the buffer is 80 characters. The usernI 	! is prompted for his access code by the text specified in "msg_access". G 	! To have a different prompt spoken, the character string "msg_access"RF 	! should be modified. Currently, the application waits 30 seconds forB 	! a touch tone key to be entered.  If a longer or shorter timeoutH 	! period is desired, the new timeout value (in seconds) should be movedB 	! into timeout before the call to "get_key_string". The parameterF 	! "terminator_value" will contain the character used to terminate the@ 	! key string or a timeout upon return from the "get_key_string" 	! routine.       9 	stat% = get_key_string( msg_access, T30SECOND,term_code)d# 	IF (stat% AND STS$M_SUCCESS) <> 0%  	THENt 	    stat% = access_verifyF 	    IF (term_code=DTK$K_TRM_ASTERISK OR term_code=DTK$K_TRM_TIMEOUT &7 			                  OR (stat% AND STS$M_SUCCESS) = 0%)e	 	    THEN! 		!		n; 		!  Either an invalid key string termination character wasR; 		!  entered, the key string was not entered in the timeout0> 	  	!  period specified or an invalid access code was entered.  $ 		illegal_entry = illegal_entry + 1% 		IF illegal_entry >= MAX_ENTRY  		THEN 			verify_user = 0%		! failure) 			EXIT FUNCTION			! 3 strikes you're outi 		ELSE. 		    CALL speak_text(DTK$K_WAIT, msg_invalid) 		END IF	 	    ELSE . 		EXIT check_user_loop		! Access code is valid 	ELSE  		verify_user = 0%		! failure!* 		EXIT FUNCTION			! No key string received 	END IFr     NEXTI 	! Gets the user's password entered on the touch tone keypad. The enterede@ 	! password is returned in the character buffer "password_code".H 	! Currently, the maximum size of the buffer is 80 characters.  The userH 	! is prompted for his password by the text specified in "msg_password".; 	! To have a different prompt spoken, the character string  F 	! "msg_password" should be modified. Currently, the application waitsA 	! 30 seconds for a touch tone key to be entered.  If a longer or	H 	! shorter timeout period is desired, the new timeout value (in seconds)G 	! should be moved into TIMEOUT before "get_key_string". The parameter,dF 	! "terminator_value" will contain the character used to terminate theG 	! key string or timeout upon return from the "get_key_string" routine.( 	!+ 	illegal_entry = 0%			! No bad attempts yetp  check_password:#     WHILE illegal_entry < MAX_ENTRY) 	num_input_keys = 0%9 	stat% = get_key_string(msg_password,T30SECOND,term_code) # 	IF (stat% AND STS$M_SUCCESS) <> 0%o 	THEN  	    stat% = password_verifyI 	    IF (term_code = DTK$K_TRM_ASTERISK OR term_code= DTK$K_TRM_TIMEOUT &u7 			                  OR (stat% AND STS$M_SUCCESS) = 0%)a	 	    THENn 		!n@ 		! If an invalid password code was entered, increment the countA 		! of invalid entry attempts.  If this count is greater than the	< 		! maximum allowed (specified by MAX_ENTRY), return FALSE. ? 		! Otherwise, notify the user and prompt him again. If a valid * 		! password is entered, then return TRUE. 		! $ 		illegal_entry = illegal_entry + 1% 		IF illegal_entry >= MAX_ENTRYe 		THEN 			verify_user = 0%m, 			EXIT FUNCTION		! three strikes you're out 		ELSE. 		    CALL speak_text(DTK$K_WAIT, msg_invalid) 		END IF   	    ELSE * 		EXIT check_password		! PASSWORD IS VALID 	ELSEg 		verify_user = 0%+ 		EXIT FUNCTION				! No key string receivedD 	END IFR     NEXT"     verify_user = 1%					! success     EXIT FUNCTIONg
  END FUNCTIONL  J  ! -----------------------------------------------------------------------O  !  Gets a series of touch tone keys entered on the telephone keypad terminated M  !  by a pound sign (#) or an asterisk (*).  Returns SUCCESS if the series ofLO  !  touch tone keys was received successfully.  Otherwise, FAILURE is returned.r  N  FUNCTION LONG get_key_string(STRING prompt,LONG timeout,LONG terminator_code)    %INCLUDE "DTKDEF"  +   EXTERNAL LONG FUNCTION	DTK$READ_KEYSTROKEt'   EXTERNAL LONG CONSTANT	SS$_TIMEOUT, &D 				SS$_NORMAL, & 
 				DTK$_WINK*  P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &) 		     LONG	MAX_ENTRY, T1SECOND, T2SECOND,  1    COMMON (application_specific)	LONG	voice_id, &r 						num_hold_keys, & 						num_input_keys, &i 					BYTE	hold_key_buf(80), &  						input_key_buf(80)h  C   DECLARE LONG  read_key_buf, hold_buf_ptr, ad_timeout, loc_timeout!   	loc_timeout = timeout   	IF num_hold_keys > 0% 	THENe 	!E 	!  There are Touch Tone keys in the typeahead buffer (hold_key_buf).iB 	!  The routine "read_advance_keys" is called here to read any newA 	!  keys pressed.  This is used mainly to read and process winks. F 	!  The "keys" stored in the typeahead buffer are moved into the input? 	!  buffer "input_key_buf" up to any terminator character.  ThekH 	!  terminator character is put in "terminator_value", and any remainingG 	!  characters left in the typeahead buffer are copied to the front of a 	!  the buffer.d 	! 		ad_timeout = 1%e 		GOSUB read_advance_keys " 		hold_key_buf(num_hold_keys) = 0% 		hold_buf_ptr = 0%OA 		WHILE hold_key_buf(hold_buf_ptr) <> DTK$K_TRM_NUMBER_SIGN AND &	8 		      hold_key_buf(hold_buf_ptr) <> DTK$K_TRM_ASTERISK  % 			IF hold_key_buf(hold_buf_ptr) = 0%e 			THENi 				num_hold_keys = 0% 				GO TO read_key	 			END IFn% 				input_key_buf(num_input_keys) = &r 					hold_key_buf(hold_buf_ptr)w  ' 			num_input_keys = num_input_keys + 1%G# 			hold_buf_ptr = hold_buf_ptr + 1%_ 		NEXT. 		terminator_code = hold_key_buf(hold_buf_ptr)" 		hold_buf_ptr = hold_buf_ptr + 1% 		num_hold_keys = 0% 		!A9 		!  Recopy the remaining keys in the typeahead buffer toaA 		!  the beginning of the buffer.  If the terminating keycode wastA 		!  a "#" or "*", skip over it and start recopying with the next%
 		!  keycode.E 	 ' 		UNTIL hold_key_buf(hold_buf_ptr) = 0%a9 			hold_key_buf(num_hold_keys)=hold_key_buf(hold_buf_ptr)r% 			num_hold_keys = num_hold_keys + 1%T% 			hold_buf_ptr  = hold_buf_ptr  + 1%L 		NEXT 		GO TO process_entry  	END IFe 	IF LEN(prompt) > 1% 	THENsB 	!  this test assumes that no 1 character prompts will be sent to 9 	!  dectalk.  Prompts of 1 char will be passed over here.! 	!% 		CALL speak_text(DTK$K_WAIT, prompt)- 	END IF-
  read_key: 	WHILE 1% = 1% 		!i? 		!  Read all keys entered on the touch tone keypad by the userlA 		!  and store them in the typeahead buffer "hold_key_buf". Firsth> 		!  a watchdog timer must be set before any keys can be read.	          a 		CALL set_timer(Time_45_sec)wC 		stat% = DTK$READ_KEYSTROKE(voice_id, read_key_buf, , loc_timeout)s 		CALL cancel_timer  		IF stat% = SS$_NORMALo 		THEN0 			IF (read_key_buf = DTK$K_TRM_NUMBER_SIGN OR &) 			    read_key_buf = DTK$K_TRM_ASTERISK)  			THEN  				!a+ 				!  Received key string terminator ("#")e2 				!  so reception of keystring is completed. Use1 				!  a short timeout to gather up any remainings+ 				!  touch tone keys entered by the user.*  " 				terminator_code = read_key_buf 				ad_timeout = 2%c 				GOSUB read_advance_keysi 				GO TO process_entry  			ELSEi0 				input_key_buf(num_input_keys) = read_key_buf( 				num_input_keys = num_input_keys + 1% 				loc_timeout = 10%t	 			END IF  		ELSE	IF stat% = SS$_TIMEOUTv 			THENr 				EXIT read_keyK 			ELSE	IF stat% = DTK$_WINK 				THEN 				! . 				!  DECtalk detected a wink which sometimes0 				!  indicates that the user has hungup.  This0 				!  demonstration program assumes that a WINK, 				!  does indicate the a user has hungup. 2 				!  Therefore, return so DECtalk can hangup its3 				!  phone.  If for any reason it is noticed that03 				!  spontaneous winks are occurring and the userN0 				!  at the other end of the telephone did not0 				!  hangup, then DO NOT return. Just continue! 				!  receiving touch tone keys.    				    CALL error_log(stat%)	 				    get_key_string = 0%!  				    EXIT FUNCTION 				ELSE 				    CALL error_log(stat%)=- 				    CALL LIB$STOP(stat% BY VALUE)  ! stopp
 				END IF	 			END IFr 		END IF 	NEXTn	         !yN         !  No keystring terminator ("#" or "*") entered so set the terminatingJ         !  keycode to DTK$K_TRM_TIMEOUT.  Otherwise, return all touch toneF 	!  keys entered. Finally, recopy any remaining touch tone keys in the= 	!  typeahead buffer (ttkeys) to the beginning of the buffer.i	          s$ 	terminator_code = DTK$K_TRM_TIMEOUT    PROCESS_ENTRY: ! 	hold_key_buf(num_hold_keys) = 0%m
 	CALL restartt 	get_key_string = 1% 	EXIT FUNCTION    READ_ADVANCE_KEYS:  	!G 	!  Read any keys from DECtalk into the typeahead buffer "hold_key_buf"  	!
 	WHILE 1=1 		CALL set_timer(Time_45_sec)iB 		stat% = DTK$READ_KEYSTROKE(voice_id, read_key_buf, , ad_timeout) 		CALL cancel_timerl 		IF stat% = SS$_NORMALe 		THEN- 			hold_key_buf(num_hold_keys) = read_key_bufu% 			num_hold_keys = num_hold_keys + 1%e 		ELSE	IF stat% = SS$_TIMEOUTn# 			THEN				! no key pressed: return 
 				RETURN 			ELSE	IF stat% = DTK$_WINK 				THEN			! Hung up?  exity 					CALL error_log(stat%) 					get_key_string = 0%  					EXIT FUNCTION	 				ELSE 					CALL error_log(stat%)) 					CALL LIB$STOP(stat% BY VALUE)	! StopE
 				END IF	 			END IFr 		END IF 	NEXTh  
  END FUNCTION     M  !***************************************************************************rL  ! Verifies the access code received from the customer.  This routine alwaysD  ! returns SUCCESS for the purpose of this demonstration.  In a realP  ! application, the code would be verified against access codes in the database.    FUNCTION LONG access_verify ()    	access_verify = 1%e 	EXIT FUNCTION  
  END FUNCTIONE  M  !*************************************************************************** H  ! Verifies the password received from the customer. This routine alwaysD  ! returns SUCCESS for the purpose of this demonstration.  In a realL  ! application, the password would be verified against their password in the  ! database.  !  FUNCTION LONG password_verify ()e   	password_verify = 1%a 	EXIT FUNCTION
  END FUNCTIONt  M  !***************************************************************************rG  !  Prompts the user for a command and receives the command (touch tonetJ  !  key) from the user.  Note, the command will be accepted whether or notE  !  it is terminated with the pound key "#".  However, if the commandtG  !  is not followed by the pound key, the command will not be processeduO  !  until the timeout period has expired and a warning message has been spoken.nM  !  When commands are received, the routine "process_menu_entry" is performed:!  !  to implement the menu choice.R  !  SUB menu()y    %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT STS$M_SUCCESS'   EXTERNAL LONG FUNCTION	get_key_string   0   COMMON (MESSAGE_TEXT) STRING  rsbracket = 1, & 				msg_welcome  = 60,&  				msg_access   = 100, &E 				msg_password = 100, &  				msg_invalid  = 40, & 				msg_bad_command   = 40, &	 				msg_no_terminator  = 100, &  				msg_noaccess = 100, &t 				msg_goodbye  = 100, &m 				msg_timeout  = 50, & 				menu_prompt  = 100, &  				msg_help     = 320, &N 				msg_weather  = 475, &t 				msg_MBTA     = 365, &d 				msg_mortgage = 500, &i 				msg_ski      = 770  P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &4 		     LONG	MAX_ENTRY, T1SECOND, T2SECOND, T20SECOND  0   COMMON (application_specific)	LONG	voice_id, & 					num_hold_keys, &_ 					num_input_keys, & 				BYTE	hold_key_buf(80), & 					input_key_buf(80)  4   DECLARE	LONG	terminator_value, illegal_entry_count  	null_char$ = X'00'Ce 	terminator_value = 0% 	illegal_entry_count = 0%s 	num_input_keys = 0%    GET_INPUT:T$ 	WHILE (input_key_buf(0) <> 0% OR  &* 				terminator_value <> DTK$K_TRM_TIMEOUT) 	!> 	! Keep getting commands from the user until the exit key "*",A 	! is entered, a wink is detected, or the timeout period expires.sG 	! First, check if there are any keys in the typeahead buffer (done by .D 	! "get_key_string" with a 1 second timeout).  If so, process them. F 	! Otherwise, prompt the user for a command and wait for his response. 	! 	input_key_buf(0) = 0%F         stat% = get_key_string(null_char$, T1SECOND, terminator_value)  " 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN$
 		EXIT SUB 	END IF!) 	IF terminator_value = DTK$K_TRM_ASTERISKt 	THEN 
 		EXIT SUB3 	ELSE	IF (terminator_value = DTK$K_TRM_NUMBER_SIGN)d 		THEN: 			GOSUB process_menu_entry	! Valid command so process it	 			GO TO  get_input"7 		ELSE IF ((terminator_value <> DTK$K_TRM_TIMEOUT) OR	& 6 	        	 (terminator_value = DTK$K_TRM_TIMEOUT AND	& 				input_key_buf(0) = 0%))N 			!: 			!  No keys in typeahead buffer so prompt for a command. 			! 		     THENS, 				CALL speak_text(DTK$K_WAIT, menu_prompt)
 		     END IFi 	         END IF 	     END IF 	!A 	!  Any new keys received should be processed after the keys readMB 	!  from the typeahead buffer.  Start storing touch tone keys intoF 	!  into the buffer following the keys read from the typeahead buffer. 	!G         stat% = get_key_string(null_char$, T20SECOND, terminator_value)i  " 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENo
 		EXIT SUB 	END IF ) 	IF terminator_value = DTK$K_TRM_ASTERISKp 	THENb
 		EXIT SUB4 	ELSE	IF (terminator_value = DTK$K_TRM_TIMEOUT AND & 				input_key_buf(0) <> 0%)  		THEN) 			CALL speak_all_text(msg_no_terminator)e: 			GOSUB process_menu_entry	! Valid command so process it	  6 		ELSE 	IF (terminator_value = DTK$K_TRM_TIMEOUT AND & 				input_key_buf(0) = 0%) 			THENe$ 				CALL speak_all_text(msg_timeout) 				EXIT SUB 			ELSEi 				GOSUB  process_menu_entrye	 			END IFb 		END IF 	END IF     NEXT 	 	EXIT SUBh  PROCESS_MENU_ENTRY:  !?  !  Processes the touch tone key string received from the user.s  ! 	IF num_input_keys > 1%  	THEN  	!< 	!  Only single key commands are valid in this menu.  Inform< 	!  the user that an invalid command was entered and return. 	!& 		CALL speak_all_text(msg_bad_command)0 		illegal_entry_count = illegal_entry_count + 1% 	ELSE	 	    SELECT	input_key_buf(0)0 		CASE = 	DTK$K_TRM_ZERO			! Speak menu help msg( 			CALL speak_text(DTK$K_WAIT, msg_help) 			illegal_entry_count = 0% 4 		CASE = 	DTK$K_TRM_ONE			! Boston weather forecast	+ 			CALL speak_text(DTK$K_WAIT, msg_weather)o 			illegal_entry_count = 0%p0 		CASE = 	DTK$K_TRM_TWO			! transportation info	( 			CALL speak_text(DTK$K_WAIT, msg_MBTA) 			illegal_entry_count = 0% 1 		CASE = 	DTK$K_TRM_THREE			! mortgage rate info	h, 			CALL speak_text(DTK$K_WAIT, msg_mortgage) 			illegal_entry_count = 0%	0 		CASE = 	DTK$K_TRM_FOUR			! ski condition info	' 			CALL speak_text(DTK$K_WAIT, msg_ski)+ 			illegal_entry_count = 0%_ 		CASE ELSEL+ 			CALL speak_text(DTK$K_WAIT, msg_invalid)I1 			illegal_entry_count = illegal_entry_count + 1%h 	   END SELECT 	END IF  	num_input_keys = 0% 	!B 	! If user enters 3 illegal/incorrect commands, speak help message 	! 	IF illegal_entry_count >= 3 	THENa' 		CALL speak_text(DTK$K_WAIT, msg_help)l 		illegal_entry_count = 0% 	END IFa 	RETURNu    END SUB  M  !***************************************************************************eG  !  Load the user dictionary with the words and phonemic pronunciationsTG  !  stored in the sequential file specified in the foreign command linetI  !  invoking the program.  Each line of this file contains the word to beaG  !  defined in the user dictionary followed by a space, followed by theSI  !  phonemic pronunciation of the word.  The entry is parsed to find the 	N  !  start and finnish of the word and it's replacement.  The word and phonemicM  !  pronunciation are loaded into the user dictionary. If the load dictionarynN  !  command fails, the user is notified and processing is terminated.  ReturnsM  !  SUCCESS if the dictionary is loaded successfully or if no user dictionaryb<  !  file name is specified.  Otherwise, FAILURE is returned.     FUNCTION LONG load_dictionary()    %INCLUDE "DTKDEF"  ,   EXTERNAL LONG FUNCTION	DTK$LOAD_DICTIONARY&   EXTERNAL LONG CONSTANT	SS$_NORMAL, & 				DTK$_TOOLONG, DTK$_NOROOM @   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min  0   COMMON (application_specific)	LONG	voice_id, & 					num_hold_keys, &p 					num_input_keys, & 				BYTE	hold_key_buf(80), & 					input_key_buf(80), & $ 				STRING	dictionary_file_name = 80  / 	MAP (dictionary) STRING dictionary_entry = 256a( 	DECLARE STRING		diction_word,  phonetic% 	DECLARE LONG		word_count, phonem_end   
 	sp$ = X'20'Cr 	tab$ = X'09'C  	null_char$ = X'00'CA 	ON ERROR GOTO ERROR_CHECKG 	IF LEFT$(dictionary_file_name,1) = null_char$	! No dictionary filenamer 	THENs6 	  !  No dictionary was specified in the command line.# 	  !  Return to initialize_dectalk X 		load_dictionary = 1% 		exit functione 	END IF(  A 	OPEN dictionary_file_name AS FILE #1,	ORGANIZATION SEQUENTIAL, &$! 						ACCESS READ, MAP DICTIONARYl 	!E 	! Since there is no timeout associated with the DTK$LOAD_DICTIONARY yC 	! command, it is possible for an application to hang waiting for arF 	! response after issuing the DTK$LOAD_DICTIONARY command.  Therefore,G 	! arm a watchdog timer (6 minutes in this case) to time the loading of%G 	! the entire user dictionary.  If all the entries are not loaded into aA 	! the user dictionary before the timer expires, then assume thatL7 	! something is wrong with the DECtalk module and exit.i 	!: 	CALL set_timer(time_6_min)		! Set system (watchdog) timer        WHILE 1 = 1 	GET #1	 	! _3 	!  Read in all of the words and substitutions frome8 	!  the sequential file specified in the command string. 	!0  !	print "dictionary_entry = ", dictionary_entry+ 	word_count = POS(dictionary_entry, sp$, 1)p 	IF word_count = 0%r2 	THEN		word_count = POS(dictionary_entry, tab$, 1) 	END IF	2 	phonem_end = POS(dictionary_entry, null_char$, 1)  7 	diction_word =	SEG$(dictionary_entry, 1, word_count-1)N> 	phonetic =	SEG$(dictionary_entry, word_count+1, phonem_end-1)  > 	stat% = DTK$LOAD_DICTIONARY(voice_id, DICTION_WORD, phonetic)1 	IF (stat% = DTK$_TOOLONG OR stat% = DTK$_NOROOM)t 	THENa 	     !t9 	     !  These are not generally fatal errors.  However, e: 	     !  they will be treated as such.  In creating a demo9 	     !  program, if words cannot be loaded into the user > 	     !  dictionary, the programmer should be notified so that@ 	     !  the appropriate action can be taken.  By treating these? 	     !  errors as fatal, the programmer will at least know theT7 	     !  point in the program where the error occurred.  	     !n/  !		print "ERROR -- Loading user dictionary.  "d   !		print "WORD: ", diction_word-  !		print "PHONETIC SUBSTITUTION: ", phoneticp
 		CLOSE #1 		CALL error_log(stat%)y 		load_dictionary = 0%' 		EXIT FUNCTION			! Fatal error so exit*/ 	ELSE IF (stat% <> SS$_NORMAL) 	! Fatal failure*
 	     THEN- 			CALL cancel_timer		! Cancel watchdog timero 			CLOSE #1t 			CALL error_log(stat%)6 			CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit 	     END IF 	END IFt	      NEXT   	!#7 	!  Entire dictionary is loaded so cancel system timer.p 	!  DONE:4 	CALL cancel_timer			! Cancel system(watchdog) timer$ 	CLOSE #1				! Close dictionary file 	load_dictionary = 1%   EXIT FUNCTION  
  ERROR_CHECK:h( 	IF ERR = 11%		! IF End of File is found 	THEN 
 		RESUME DONEe 	ELSEh 	   CALL error_log(VMSSTATUS)N 	   RESUME HERE  HERE:N 	   load_dictionary = 0% 	   EXIT FUNCTIONN 	END IFN
  END FUNCTION   M  !***************************************************************************	H  !  DECtalk stopped speaking because it was in autostop keypad mode whenG  !  it received a Touch Tone Key from the user.  First, send DECtalk a 	K  !  right square bracket "]" just in case speech was stopped while speaking&M  !  phonemic text. Then, restart speech (using DTK$SET_SPEECH_MODE) and reset56  !  the speaking voice and rate (using DTK$SET_VOICE).  !  SUB restart()    %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT	STS$M_SUCCESS/   EXTERNAL LONG FUNCTION	DTK$SET_SPEECH_MODE, &R 				DTK$SET_VOICEN  -   COMMON (MESSAGE_TEXT) STRING  rsbracket = 1OM   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_mineI   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, &l# 		 period_pause_duration, speech_onr-   COMMON (application_specific)	LONG	voice_id   6   DECLARE LONG old_mode				! Current mode before reset  ( 	CALL speak_text( DTK$K_WAIT, rsbracket) 	! 	!  Set speaking onE 	! 	CALL set_timer(Time_45_sec); 	stat% = DTK$SET_SPEECH_MODE(voice_id, speech_on, old_mode)l 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENr 		CALL error_log(stat%)e5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitl 	END IF$ 	!% 	!  Reset the voice and speaking rater 	CALL set_timer(Time_45_sec)8 	stat% = DTK$SET_VOICE(voice_id, voice, speaking_rate, &0 				comma_pause_duration, period_pause_duration) 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN  		CALL error_log(stat%)F5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit  	END IF     END SUB  M  !*************************************************************************** E  !  End the current user session.  Since the DTK$HANGUP_PHONE command C  !  does not set a timeout, and it requests DECtalk to send a phoneeG  !  status, a watchdog timer is set to insure that the application doesIG  !  not hang (if DECtalk fails).  If a longer timeout period is needed,eH  !  adjust the value of the parameter moved into SET_TIMER_STRING beforeM  !  performing "set_timer".  After the watchdog timer is set, speak a goodbye I  !  message to the caller and then hangup the phone.  The goodbye messageMB  !  spoken can be changed by modifying the text in "msg_goodbye".   !  SUB end_call ()  )   EXTERNAL LONG CONSTANT	STS$M_SUCCESS, &_ 				SS$_TIMEOUT, & 				DTK$_ONHOOK   -   EXTERNAL LONG FUNCTION 	DTK$HANGUP_PHONE, &  				DTK$READ_KEYSTROKE  0   COMMON (MESSAGE_TEXT) STRING  rsbracket = 1, & 				msg_welcome  = 60,&  				msg_access   = 100, &o 				msg_password = 100, &n 				msg_invalid  = 40, & 				msg_bad_command   = 40, &r 				msg_no_terminator  = 100, &a 				msg_noaccess = 100, &	 				msg_goodbye  = 100  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min_-   COMMON (application_specific)	LONG	voice_idt  : 	CALL set_timer(time_6_min)		! Set system (watchdog) timer 	!$ 	!  Say goodbye and hangup the phone 	!0 	stat% = DTK$HANGUP_PHONE(voice_id, msg_goodbye)* 	CALL cancel_timer			! Cancel system timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENa 		CALL error_log(stat%)T5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitH 	END IFo 	!F 	!  This section of code has been added as a workaround for processingE 	!  WINKS at the end of a phone session.  These will be taken care of	! 	!  by the RTL in later releases.i 	! 	timeout% = 1% 	WHILE 1% = 1%? 	    CALL set_timer(time_45_sec)		! Set system (watchdog) timerg: 	    stat% = DTK$READ_KEYSTROKE(voice_id, xx%, , timeout%). 	    CALL cancel_timer			! Cancel system timer  6 	    IF (stat% = DTK$_ONHOOK) OR (stat% = SS$_TIMEOUT)	 	    THENa< 		CALL set_timer(time_45_sec)		! Set system (watchdog) timer7 		stat% = DTK$READ_KEYSTROKE(voice_id, xx%, , timeout%) + 		CALL cancel_timer			! Cancel system timer*  # 		IF (stat% AND STS$M_SUCCESS) = 0%* 		THEN 		    CALL error_log(stat%)t9 		    CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit  		END IF 		EXIT SUB		  + 	    ELSE IF (stat% AND STS$M_SUCCESS) = 0%e 		 THEN  		    CALL error_log(stat%)i9 		    CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exito	 		 END IFa 	    END IFb 	NEXT     END SUB  J  !  ----------------------------------------------------------------------J  !  Speak all text -- disable autostop keypad, speak text in prompt using :  !  "speak_text". If autostop was set, re-enable autostop.  !#  SUB speak_all_text (STRING prompt)n    %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT	STS$M_SUCCESS,   EXTERNAL LONG FUNCTION	DTK$SET_KEYPAD_MODE  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, &UP         period_pause_duration, speech_on, new_mode, number_of_rings, keypad_mode-   COMMON (application_specific)	LONG	voice_idi     DECLARE LONG	keypad_on     keypad_on = DTK$K_KEYPAD_ONp 	!F 	!  If autostop keypad mode is enabled (keymode = DTK$K_KEYPAD_AUTO), 1 	!  then enable the keypad without autostop mode.  	!C 	IF (keypad_mode = DTK$K_KEYPAD_AUTO)	! Keypad is in autostop mode	i 	THENn7 		CALL set_timer(Time_45_sec)	! Set the watchdog timer	C2 		stat% = DTK$SET_KEYPAD_MODE(voice_id, keypad_on)1 		CALL cancel_timer		! Cancel the watchdog timer	 # 		IF (stat% AND STS$M_SUCCESS) = 0%y 		THEN 			CALL error_log(stat%)6 			CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit 		END IF 	END IFd  ( 	!  Send text to DECtalk to be spoken.  = 	!  Specify the mode as DTK$K_WAIT so that text is completelyi< 	!  spoken before the keypad is re-enabled in autostop mode.  $ 	CALL speak_text(DTK$K_WAIT, prompt)  ' 	!  If autostop keypad mode was enabledt9 	!  (keypad_mode = DTK$K_KEYPAD_AUTO), then re-enable it.  	!D 	IF (keypad_mode = DTK$K_KEYPAD_AUTO) ! Keypad was in autostop mode	 	THENN4 		CALL set_timer(Time_45_sec)	! Set watchdog timer		4 		stat% = DTK$SET_KEYPAD_MODE(voice_id, keypad_mode)1 		CALL cancel_timer		! Cancel the watchdog timer	l# 		IF (stat% AND STS$M_SUCCESS) = 0%b 		THEN 			CALL error_log(stat%)6 			CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit 		END IF 	END IFL  END SUB  M  !*************************************************************************** .  !  Sends the prompt (specified by prompt) to 1  !  the DECtalk to be spoken.  Returns SUCCESS ifa>  !  everything is spoken o.k.  Otherwise, FAILURE is returned.  !  7  !  NOTE:  If DTK$SPEAK_TEXT is called with mode set to=8  !	   DTK$K_WAIT or DTK$K_STATUS, a phone status requestA  !	   is sent from DECtalk.  Since there is no timeout associatedc>  !	   with this request, a system timer should be set (to someG  !	   exteremely long value (16 minutes) to insure that the application_  !	   does not hang.  !8  SUB speak_text (LONG return_status_mode, STRING prompt)    %INCLUDE "DTKDEF"  )   EXTERNAL LONG CONSTANT	STS$M_SUCCESS, &t 				SS$_NORMAL'   EXTERNAL LONG FUNCTION	DTK$SPEAK_TEXTs  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_mine  -   COMMON (application_specific)	LONG	voice_id  	! 	!  Speak the text: 	CALL set_timer(time_16_min)	! Set system (watchdog) timer= 	stat% = DTK$SPEAK_TEXT(voice_id, prompt, return_status_mode)T) 	CALL cancel_timer		! Cancel system timerr 	IF (stat% <> SS$_NORMAL)! 	THEN  		CALL error_log(stat%)c5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitn 	END IFI  END SUB  I  ! ********************************************************************** /  !	Log error to the operator console  "OPER11".S  !N  !  Take the error number, input to SYS$GETMSG to get the system message text.P  !  Format the message text with the specific terminal line for that applicationL  !  "process" (using SYS$FAO), and call SYS$SENOPR with the error structure.  !H  !  NOTE:  the DTK$ errors that occur will have the %DTK- facility name,B  !	  but not the error message text, just the error number.  It isG  !	  anticipated that these messages will be included in future VMS/RTL   !	  releases.  !!  SUB error_log(LONG error_number)U  B  %INCLUDE "$OPCDEF" %FROM %LIBRARY "SYS$LIBRARY:BASIC$STARLET.TLB"  #   EXTERNAL LONG CONSTANT	SS$_NORMALT#   EXTERNAL LONG FUNCTION	SYS$FAO, &  				SYS$SNDOPR, &* 				SYS$GETMSG  0   COMMON (application_specific)	LONG	voice_id, & 					num_hold_keys, &b 					num_input_keys, & 				BYTE	hold_key_buf(80) , &i 					input_key_buf(80), &h' 				STRING	dictionary_file_name = 80, &h 					terminal_line  B   MAP	(error_struct) LONG opc$type_target, LONG OPC$L_MS_RQSTID, & 			STRING error_text = 120+   MAP	(error_struct) STRING error_msg = 128i%   MAP   (temp)  STRING error_buf = 80.  +   DECLARE STRING CONSTANT filler = "  ON  " 3   DECLARE STRING CONSTANT control_str = "!AD!AS!AD"    DECLARE LONG buf_len  P     temp% = SYS$GETMSG(error_number by value, buf_len, error_buf, 15% by value,)  !A  ! Set message target to OPER11, and the message type to RQ_RQST.iD  ! For more information on sending messages to an operators terminal"  ! see the System Services manual.  !>     opc$type_target = (OPC$M_NM_OPER11 * 256%) OR OPC$_RQ_RQST  5 	temp% = SYS$FAO(control_str, buf_len, error_text,		& ) 				buf_len by value, error_buf by ref,	& . 				filler, 5% by value, terminal_line by ref)1 	WHILE MID$(error_text, buf_len + 1, 1) <> X"00"Cn+ 		MID$(error_text, buf_len + 1, 1) = X"00"CA 		buf_len = buf_len + 1T 	NEXT	+ 	stat% = SYS$SNDOPR(error_msg, 0% by value) 2 	IF (stat% <> SS$_NORMAL)			! Send to oper failed	 	THENh5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit. 	END IF   END SUB  M  !*************************************************************************** J  !  Sets the system (watchdog) timer to expire "sec" seconds in the futureI  !  by invoking the "SYS$SETIMR" system service.  SYS$BINTIM is passed a  L  !  character string in the format "D HH:MM:SS", where D is Days, H is HoursH  !  M is minutes etc.  The output of BINTIM is the quadword delta_time ,/  !  which gets passed as input to SYS$SETIMR.  h  !"  SUB set_timer(STRING time_string)  ( 	EXTERNAL LONG CONSTANT	STS$M_SUCCESS, & 				SS$_TIMEOUTa% 	EXTERNAL LONG FUNCTION	SYS$SETIMR, &  				SYS$BINTIM: 	EXTERNAL LONG		LIB$SIGNAL 	! Indicate exception condition% 	MAP (quadword) LONG delta_time, FILL	  , 	stat% = SYS$BINTIM(time_string, delta_time)# 	IF (stat% AND STS$M_SUCCESS)  = 0%* 	THEN* 		CALL error_log(stat%)*5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitn 	END IFs  K 	stat%= SYS$SETIMR( ,delta_time, LIB$SIGNAL BY VALUE, SS$_TIMEOUT BY VALUE)r# 	IF (stat% AND STS$M_SUCCESS)  = 0%  	THEN  		CALL error_log(stat%)o5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitC 	END IFs  END SUB  J  !  ----------------------------------------------------------------------$  !  Cancel the system watchdog timer  !  SUB cancel_timer()r  %  EXTERNAL LONG CONSTANT	STS$M_SUCCESSy?  EXTERNAL LONG FUNCTION	SYS$CANTIM		! Cancel SYS$SETIMR requestd  6 	stat% = SYS$CANTIM(SS$_TIMEOUT BY VALUE, 0% BY VALUE)" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN) 		CALL error_log(stat%)A5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitO 	END IFX  END SUB