 	%TITLE "DECTALK-RESULTS.BAS"   !  !				RESULTS.BAS   !  7  !	NOTE:  This program was written with VAX BASIC V3.0.   !=  !  The following file contains a version of the "modifiable" E  !  demonstration program that is included in the DECtalk Application A  !  Development Guide.  This version of the demonstration program D  !  shows how DECtalk can be used to report laboratory and radiologyK  !  results.  The demonstration program typifies most telephone application F  !  programs written for DECtalk.  It is written in VAX BASIC and usesF  !  Version 4.5 or later of the VMS/MicroVMS Run-Time Library Support   !  provided for DECtalk.   !C  !	Program description:  In the "MENU" subroutine there is a SELECT =  !		statement where the code determines which of 3 menu items :  !		are chosen.  The menu choices and menu message must be9  !		modified to reflect the menu items being implemented.   !		The menu choices are:   !  !			A) Laboratory Results  !			B) Radiology Results #  !			C) DECtalk Product Information   !@  !		All error messages are logged only to the operator terminals>  !		that have specified that the "OPER11" type of message will>  !		be handled. These messages give the error message, and the;  !		terminal line connected to that process.  To have error C  !		messages logged to the console terminal, or any other terminal, :  !		at the DCL prompt ($), enter the REPLY/ENABLE command:  !  !			$ reply/enable=oper11  !A  !		To enter this command, you must have the OPER user privelege.   !    %INCLUDE "DTKDEF"  (  EXTERNAL LONG CONSTANT	STS$M_SUCCESS, & 			SS$_NORMAL,   & 			SS$_TIMEOUT  !8  !  EXTERNAL Run-time Library Routines (DECtalk support)  !  EXTERNAL LONG FUNCTION & 0 			DTK$ANSWER_PHONE,	! Wait for phone to ring !&2 			DTK$INITIALIZE, 	! Initialize DECtalk device !&3 			DTK$TERMINATE, 		! End initialized DECtalk use!&  			initialize_dectalk   !  !  Prompts and demo text   !5   COMMON (MESSAGE_TEXT) STRING  msg_access   = 100, &  				msg_invalid  = 40, & 				msg_bad_command   = 40, &  				msg_no_terminator  = 100, &  				msg_timeout  = 50, & 				customer_service = 160, &  				dispatch_desk = 160   N    msg_policyid$ = "Please enter your policy I.D. followed by the pound-key."&, 		+ " You may enter any number as a test."		P    msg_security$ = "Please enter your security code followed by the pound-key."&* 		+ " You may enter any number as a test."6    msg_invalid  = "Invalid entry.  Please try again. "C    msg_timeout  = "No key pressed in the timeout period specified." <    msg_bad_command  = "Invalid command.  Please try again. "J    msg_no_terminator= "Please remember to terminate your entry with the "&% 		+ "pound-key.  Command accepted.  " M   customer_service = "In an actual application, DECtalk would now transfer "& I 	+ "your call to a customer service representative. This demonstration "& ) 	+ "just returns to the selection menu. "   P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &7 		     LONG	MAX_ENTRY, T1SECOND, T2SECOND, T20SECOND, & # 					T30SECOND, T5MINUTE, T15MINUTE   I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, & P         period_pause_duration, speech_on, new_mode, number_of_rings, keypad_mode  1   COMMON (application_specific)	LONG		voice_id, &  						num_hold_keys, & 						num_input_keys, &  					BYTE	hold_key_buf(80) , & 						input_key_buf(80), &( 					STRING	dictionary_file_name = 80, & 						terminal_line   0   COMMON (results_reporting)    LONG		call_count   	MAX_ENTRY = 3
 	T1SECOND = 1 
 	T2SECOND = 2  	T20SECOND = 20  	T30SECOND = 30  	T5MINUTE = 300  	T15MINUTE = 900 	TIME_45_SEC = "0 00:00:45"  	TIME_90_SEC = "0 00:01:30"  	TIME_6_MIN  = "0 00:06:00"  	TIME_16_MIN = "0 00:16:00"  	voice = DTK$K_VOICE_MALE  	speaking_rate = 180 	comma_pause_duration = 0  	period_pause_duration = 0 	speech_on = DTK$K_SPEAK 	new_mode = DTK$M_SQUARE  	keypad_mode = DTK$K_KEYPAD_AUTO 	call_count = 0%  M    msg_welcome$  = "Welcome to Digital's [l'aebraxtoriy] Results Reporting "&  		 + "Demonstration.  "     %page  ! main   -  DECLARE LONG	version, init_dtk, need_to_init   init_dtk = 0%  need_to_init = 0% 	!A 	! Get the name of the physical device that the DECtalk module is B 	! connected to and the name of the dictionary file (if specified)A 	! that contains DECtalk's user dictionary words. If the call to  - 	! DTK$INITIALIZE is unsuccessful, then exit.  	!9 	CALL get_cli_params(terminal_line, dictionary_file_name)    	call set_timer(Time_45_sec)9 	stat% = DTK$INITIALIZE(voice_id, terminal_line, version)  	call cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN  		CALL error_log(stat%) 5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit  	END IF     WHILE_LOOP: 	WHILE 1% = 1%			! do always   	num_hold_keys = 0%  	num_input_keys = 0%  9 	 !  Check to see if the DECtalk needs to be initialized. < 	 !  (init_dtk = need_to_init = 0).  If so, reinitialize theC  	 !  application specific parameters.  Then, set a watchdog timer  B 	 !  for 16 minutes in the future in case the DECtalk module fails@ 	 !  and no response to the DTK$ANSWER_PHONE command is received> 	 !  from DECtalk.  ** NOTE:  MAKE SURE THE WATCHDOG TIMER IS : 	 !  ALWAYS SET TO A VALUE LARGER THAN THE TIMEOUT PERIOD C 	 !  SPECIFIED IN THE DTK$ANSWER_PHONE COMMAND.  THE WATCHDOG TIMER / 	 !  CAN BE LARGER THAN 16 MINUTES.  Next, wait B 	 !  for the phone connected to the DECtalk to ring.  If the phone? 	 !  does not ring in "timeout" seconds (or the watchdog timer  B 	 !  times out), normally, the status of the DECtalk unit would beA 	 !  checked.  This is not possible in the current version (V4.5) A 	 !  of the VMS Run-Time Library Support for DECtalk.  Therefore, H 	 !  instead of reinitializing DECtalk every time the unit power cycled,C 	 !  it is reinitialized every time no phone calls are received in  G 	 !  "timeout" seconds. Then, a greeting message is spoken to the user. 
          ! 	IF init_dtk = need_to_init @ 	THEN  stat% = initialize_dectalk		! Reinitialize DECtalk paramS# 		IF (STAT% AND STS$M_SUCCESS) = 0%  		THEN- 			!  Initialization failed.  It appears that 0 			!  the DECtalk module may be dead.  For now,  			!  I will exit.    			GO TO out			! End the program 		END IF9 	    init_dtk = NOT need_to_init			! Appl. init. complete  	END IF ; 	CALL set_timer(time_16_min)		! Set system (watchdog) timer  	!G 	! The greeting message DECtalk speaks upon answering the telephone can ; 	! be modified by changing the text in the character string A 	! "msg_welcome". The number of rings DECtalk waits to answer the F 	! telephone ("number_of_rings"), can be changed but it is recommended7 	! that the phone is always answered on the first ring.  	!K         stat% = DTK$ANSWER_PHONE(voice_id, number_of_rings, msg_welcome$, &  								T15MINUTE) 	CALL cancel_timer 	IF (stat% = SS$_NORMAL) 	THEN  		! ' 		!  The telephone has been answered.    		! A 		!  NOTE: DTK$ANSWER_PHONE automatically enables autostop keypad 6 		!	 mode, and wink detection on the telephone keypad. 		!  		CALL menu  		CALL end_call 9 	ELSE IF (stat% = SS$_TIMEOUT)			! Timeout period expired 
 	     THEN2 		init_dtk = need_to_init			! Have to reinitialize
 	     ELSE 		CALL error_log(stat%) 6 		CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exit 	     END IF 	END IF      NEXT    out:A     !  some fatal error has occured... Terminate DECtalk and exit      !      CALL set_timer(Time_45_sec) C     stat% = DTK$TERMINATE(VOICE_ID)     ! End use of DECtalk device      CALL cancel_timer %     IF (stat% AND STS$M_SUCCESS) = 0%      THEN 		CALL error_log(stat%) 
     END IF     END  N  !********************* END OF PROGRAM ***************************************  !C  ! Gets the parameters from the command line using LIB$GET_FOREIGN. C  ! If a fatal error occurs, it is reported and the demo is stopped. K  ! Otherwise, the parameters specified are returned in terminal_line_string P  ! for the device name, and dictionary_name for the name of the dictionary file.  !A  SUB  get_cli_params (STRING device_name, STRING dictionary_name)   % 	EXTERNAL LONG CONSTANT STS$M_SUCCESS ' 	EXTERNAL LONG FUNCTION LIB$GET_FOREIGNp   	DECLARE STRING get_param_buf 0 	DECLARE LONG device_length, diction_name_length  * 	stat% = LIB$GET_FOREIGN(get_param_buf,,,)" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENc 		CALL error_log(stat%)u6 		CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exit 	END IFE+ 	device_length = POS(get_param_buf, " ", 1)d) 	diction_name_length = LEN(get_param_buf)g   	IF device_length = 0% 	THENc: 		device_name = SEG$(get_param_buf,1, diction_name_length) 	ELSEI9 		device_name = SEG$(get_param_buf, 1, device_length - 1)n9 		dictionary_name = SEG$(get_param_buf, device_length+1,&P 						 diction_name_length)M 	END IFo	   END SUB     K  !*************************************************************************	?  !  Initializes the application specific parameters of DECtalk.iD  !  First, left square bracket ('[') and right square bracket (']') M  !  are enabled as phonemic delimiters. To specify other modes, the bit maskstM  !  for the modes to be set should be OR'd together with the DTK$M_SQUARE bitrM  !  mask and assigned to the varible "NEW_MODE".  Next, the default speaking  H  !  voice and speaking rate are selected for the application.  The commaE  !  pause and period pause are set to DECtalk defaults.  Other voices I  !  can selected for the default speaking voice by modifying the variable,B  !  "voice".  Likewise, a different speaking rate can be specifiedG  !  by changing the static variable "speaking_rate".  Finally, the user F  !  dictionary is loaded (by invoking "load_dictionary").  Note, otherF  !  application specific parameters should also be initialized in this"  !  subroutine if the need arises.  !  #  FUNCTION LONG initialize_dectalk()   &   EXTERNAL LONG CONSTANT	STS$M_SUCCESS(   EXTERNAL LONG FUNCTION	DTK$SET_MODE, & 				DTK$SET_VOICE, & 				load_dictionary   M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_minT  I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, &n- 		 period_pause_duration, speech_on, new_mode -   COMMON (application_specific)	LONG	voice_id=   	CALL set_timer(Time_45_sec)+ 	stat% = DTK$SET_MODE(voice_id, new_mode, )o 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THEN  		CALL error_log(stat%)m6 		CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exit 	END IFo 	!A 	!  Indicate the type of voice and the speaking rate for DECtalk.  	CALL set_timer(Time_45_sec)7 	stat% = DTK$SET_VOICE(voice_id, voice, speaking_rate &t1 				,comma_pause_duration, period_pause_duration)d 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENe 		CALL error_log(stat%)e6 		CALL LIB$STOP(stat% BY VALUE)		! Fatal error so exit 	END IFm 	!8 	! load user dictionary using "load_dictionary" function 	!% 	initialize_dectalk = load_dictionaryc 	EXIT FUNCTION
  END FUNCTIONa  K  !  -----------------------------------------------------------------------RO  !  Gets a series of touch tone keys entered on the telephone keypad terminatedTM  !  by a pound sign (#) or an asterisk (*).  Returns SUCCESS if the series ofMO  !  touch tone keys was received successfully.  Otherwise, FAILURE is returned.i  N  FUNCTION LONG get_key_string(STRING prompt,LONG timeout,LONG terminator_code)    %INCLUDE "DTKDEF"  +   EXTERNAL LONG FUNCTION	DTK$READ_KEYSTROKE	'   EXTERNAL LONG CONSTANT	SS$_TIMEOUT, &b 				SS$_NORMAL, &n
 				DTK$_WINK,  P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &) 		     LONG	MAX_ENTRY, T1SECOND, T2SECONDE  1    COMMON (application_specific)	LONG	voice_id, &= 						num_hold_keys, & 						num_input_keys, &U 					BYTE	hold_key_buf(80), &0 						input_key_buf(80)   C   DECLARE LONG  read_key_buf, hold_buf_ptr, ad_timeout, loc_timeout    	loc_timeout = timeout   	IF num_hold_keys > 0% 	THENu 	!E 	!  There are Touch Tone keys in the typeahead buffer (hold_key_buf).wB 	!  The routine "read_advance_keys" is called here to read any newA 	!  keys pressed.  This is used mainly to read and process winks.sF 	!  The "keys" stored in the typeahead buffer are moved into the input? 	!  buffer "input_key_buf" up to any terminator character.  The_H 	!  terminator character is put in "terminator_value", and any remainingG 	!  characters left in the typeahead buffer are copied to the front of f 	!  the buffer.t 	! 		ad_timeout = 1%t 		GOSUB read_advance_keyso" 		hold_key_buf(num_hold_keys) = 0% 		hold_buf_ptr = 0%CA 		WHILE hold_key_buf(hold_buf_ptr) <> DTK$K_TRM_NUMBER_SIGN AND &e8 		      hold_key_buf(hold_buf_ptr) <> DTK$K_TRM_ASTERISK  % 			IF hold_key_buf(hold_buf_ptr) = 0%r 			THENa 				num_hold_keys = 0% 				GO TO read_key	 			END IFa% 				input_key_buf(num_input_keys) = &  					hold_key_buf(hold_buf_ptr)   ' 			num_input_keys = num_input_keys + 1% # 			hold_buf_ptr = hold_buf_ptr + 1%y 		NEXT. 		terminator_code = hold_key_buf(hold_buf_ptr)" 		hold_buf_ptr = hold_buf_ptr + 1% 		num_hold_keys = 0% 		!t9 		!  Recopy the remaining keys in the typeahead buffer toeA 		!  the beginning of the buffer.  If the terminating keycode was A 		!  a "#" or "*", skip over it and start recopying with the nextc
 		!  keycode.v 	 ' 		UNTIL hold_key_buf(hold_buf_ptr) = 0%H9 			hold_key_buf(num_hold_keys)=hold_key_buf(hold_buf_ptr)N% 			num_hold_keys = num_hold_keys + 1% % 			hold_buf_ptr  = hold_buf_ptr  + 1%H 		NEXT 		GO TO process_entryT 	END IFN 	IF LEN(prompt) > 1% 	THENtB 	!  this test assumes that no 1 character prompts will be sent to 9 	!  dectalk.  Prompts of 1 char will be passed over here.  	!% 		CALL speak_text(DTK$K_WAIT, prompt)C 	END IF 
  read_key: 	WHILE 1% = 1% 		!n? 		!  Read all keys entered on the touch tone keypad by the useriA 		!  and store them in the typeahead buffer "hold_key_buf". Firstt> 		!  a watchdog timer must be set before any keys can be read.	          d 		CALL set_timer(Time_45_sec)rC 		stat% = DTK$READ_KEYSTROKE(voice_id, read_key_buf, , loc_timeout)k 		CALL cancel_timer  		IF stat% = SS$_NORMALe 		THEN0 			IF (read_key_buf = DTK$K_TRM_NUMBER_SIGN OR &) 			    read_key_buf = DTK$K_TRM_ASTERISK)U 			THEN0 				!H+ 				!  Received key string terminator ("#")t2 				!  so reception of keystring is completed. Use1 				!  a short timeout to gather up any remainingp+ 				!  touch tone keys entered by the user._  " 				terminator_code = read_key_buf 				ad_timeout = 2%i 				GOSUB read_advance_keysc 				GO TO process_entryg 			ELSEe0 				input_key_buf(num_input_keys) = read_key_buf( 				num_input_keys = num_input_keys + 1% 				loc_timeout = 10% 	 			END IFe 		ELSE	IF stat% = SS$_TIMEOUTt 			THEN  				EXIT read_keyt 			ELSE	IF stat% = DTK$_WINK 				THEN 				!t. 				!  DECtalk detected a wink which sometimes0 				!  indicates that the user has hungup.  This0 				!  demonstration program assumes that a WINK, 				!  does indicate the a user has hungup. 2 				!  Therefore, return so DECtalk can hangup its3 				!  phone.  If for any reason it is noticed thatD3 				!  spontaneous winks are occurring and the user 0 				!  at the other end of the telephone did not0 				!  hangup, then DO NOT return. Just continue! 				!  receiving touch tone keys.o   				    CALL error_log(stat%)	 				    get_key_string = 0%a  				    EXIT FUNCTION 				ELSE 				    CALL error_log(stat%)L% 				    CALL LIB$STOP(stat% BY VALUE)s
 				END IF	 			END IFE 		END IF 	NEXT 	         ! N         !  No keystring terminator ("#" or "*") entered so set the terminatingJ         !  keycode to DTK$K_TRM_TIMEOUT.  Otherwise, return all touch toneF 	!  keys entered. Finally, recopy any remaining touch tone keys in the= 	!  typeahead buffer (ttkeys) to the beginning of the buffer. 	          !$ 	terminator_code = DTK$K_TRM_TIMEOUT    PROCESS_ENTRY:*! 	hold_key_buf(num_hold_keys) = 0% 
 	CALL restart  	get_key_string = 1% 	EXIT FUNCTION    READ_ADVANCE_KEYS:  	!G 	!  Read any keys from DECtalk into the typeahead buffer "hold_key_buf"s 	!
 	WHILE 1=1 		CALL set_timer(Time_45_sec) B 		stat% = DTK$READ_KEYSTROKE(voice_id, read_key_buf, , ad_timeout) 		CALL cancel_timerS 		IF stat% = SS$_NORMALG 		THEN- 			hold_key_buf(num_hold_keys) = read_key_bufG% 			num_hold_keys = num_hold_keys + 1%G 		ELSE	IF stat% = SS$_TIMEOUTD# 			THEN				! no key pressed: returnE
 				RETURN 			ELSE	IF stat% = DTK$_WINK 				THEN			! Hung up?  exitt 					CALL error_log(stat%) 					get_key_string = 0%  					EXIT FUNCTIONg 				ELSE 					CALL error_log(stat%)" 					CALL LIB$STOP(stat% BY VALUE)
 				END IF	 			END IFg 		END IF 	NEXT,  
  END FUNCTIONm    M  !***************************************************************************EL  ! Verifies the access code received from the customer.  This routine alwaysD  ! returns SUCCESS for the purpose of this demonstration.  In a realP  ! application, the code would be verified against access codes in the database.    FUNCTION LONG access_verify ()n   	access_verify = 1%T 	EXIT FUNCTION  
  END FUNCTIONo  M  !***************************************************************************NH  ! Verifies the password received from the customer. This routine alwaysD  ! returns SUCCESS for the purpose of this demonstration.  In a realL  ! application, the password would be verified against their password in the  ! database.  !  FUNCTION LONG password_verify ()P   	password_verify = 1%g 	EXIT FUNCTION
  END FUNCTION   M  !*************************************************************************** G  !  Prompts the user for a command and receives the command (touch tonelJ  !  key) from the user.  Note, the command will be accepted whether or notE  !  it is terminated with the pound key "#".  However, if the commandhG  !  is not followed by the pound key, the command will not be processed O  !  until the timeout period has expired and a warning message has been spoken.oM  !  When commands are received, the routine "process_menu_entry" is performedn!  !  to implement the menu choice.e  !  SUB menu()i    %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT STS$M_SUCCESS*   EXTERNAL LONG FUNCTION	get_key_string, & 				laboratory, &r 				radiology, & 				DTK$SET_VOICE   5   COMMON (MESSAGE_TEXT) STRING  msg_access   = 100, &  				msg_invalid  = 40, & 				msg_bad_command   = 40, &  				msg_no_terminator  = 100, &c 				msg_timeout  = 50, & 				customer_service = 160  P   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_min, &4 		     LONG	MAX_ENTRY, T1SECOND, T2SECOND, T20SECOND  I   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, &N 				 period_pause_duration  0   COMMON (application_specific)	LONG	voice_id, & 					num_hold_keys, &o 					num_input_keys, & 				BYTE	hold_key_buf(80), & 					input_key_buf(80)  D   main_menu$	= "For [l'aebraxtoriy] results, press 1, followed by "&? 	+ "the pound-key.  For [reydiy'aolaxjhiy] results, press 2, "& D  	+ "followed by the pound-key.  For DECtalk product information, "&C 	+ "press 3, followed by the pound-key.  To repeat this message, "&rH 	+ "press 0, followed by the pound-key.  To exit, press the star key.  "  L   dtcfamily$	= "[+] The [`]DECtalk [`]Voice Response-System is the latest "&I 	+ "addition to Digital's Voice solutions. It features the performance "&dD 	+ "of the MicroVAX 2, plus the flexibility of the foremost voice "&F 	+ "synthesis product on the market today.  The [`]DECtalk [`]Voice "&F 	+ "Response-System is sized to support from 2 to 32 DEctalk lines. "&H 	+ "It is ideally suited to front end large data-bases. Packaged with "&I 	+ "the [`]DECtalk [`]Voice Response-System is the DECtalk Application "&-E 	+ "Development-Guide.  This guide consists of a user's manual and "&nC 	+ "sample application-software. It is designed to significantly "&tG 	+ "reduce the time required to develop a voice response application "&uI 	+ "for any of the DEctalk products. DECtalk component products include"&IH 	+ " Dual-Line DECtalk, a two-line subsystem, and Multi-line DECtalk, "&D 	+ "an eight-line subsystem, both of which are rack mountable. In "&F 	+ "addition, the DECtalk board can be used to expand the number of "&H 	+ "lines needed.  [+] Single line DECtalk is a table-top unit with a "&> 	+ "built-in loud-speaker. It is best for [st'aend#axl`own] "&I 	+ "applications, such as aids for the handicapped. It is also commonly"&	I 	+ " used in manufacturing, for [m'aonaxtaxrixnx] status on the factory"&dH 	+ " floor. [+] All DECtalk products appropriately pronounce commonly "&E 	+ "occurring forms, such as numbers, money, abbreviations, dates, "&n& 	+ "times, and [paxnxkchuw'eyshaxn]. "     4   DECLARE	LONG	terminator_value, illegal_entry_count  	null_char$ = X'00'Cd 	terminator_value = 0% 	illegal_entry_count = 0%   $ 	WHILE (input_key_buf(0) <> 0% OR  &* 				terminator_value <> DTK$K_TRM_TIMEOUT) 	!> 	! Keep getting commands from the user until the exit key "*",A 	! is entered, a wink is detected, or the timeout period expires.rG 	! First, check if there are any keys in the typeahead buffer (done by  D 	! "get_key_string" with a 1 second timeout).  If so, process them. F 	! Otherwise, prompt the user for a command and wait for his response. 	!  GET_SHORT_READ: 	num_input_keys = 0% 	input_key_buf(0) = 0%F         stat% = get_key_string(null_char$, T1SECOND, terminator_value)  " 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENO
 		EXIT SUB 	END IFI) 	IF terminator_value = DTK$K_TRM_ASTERISK  	THENl
 		EXIT SUB3 	ELSE	IF (terminator_value = DTK$K_TRM_NUMBER_SIGN)1 		THEN: 			GOSUB process_menu_entry	! Valid command so process it	) 			IF (input_key_buf(0) = DTK$K_TRM_ZERO)r 			THENu 				GO TO get_long_ready 			ELSE	 				GO TO get_short_read	 			END IF 7 		ELSE IF ((terminator_value <> DTK$K_TRM_TIMEOUT) OR	&r6 	        	 (terminator_value = DTK$K_TRM_TIMEOUT AND	& 				input_key_buf(0) = 0%))n 			!: 			!  No keys in typeahead buffer so prompt for a command. 			! 		     THENl+ 				CALL speak_text(DTK$K_WAIT, main_menu$)f
 		     END IFh 	         END IF 	     END IF 	!A 	!  Any new keys received should be processed after the keys read B 	!  from the typeahead buffer.  Start storing touch tone keys intoF 	!  into the buffer following the keys read from the typeahead buffer. 	!  GET_LONG_READ:e 	num_input_keys = 0%G         stat% = get_key_string(null_char$, T20SECOND, terminator_value)	  " 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENy
 		EXIT SUB 	END IF ) 	IF terminator_value = DTK$K_TRM_ASTERISKl 	THENu
 		EXIT SUB4 	ELSE	IF (terminator_value = DTK$K_TRM_TIMEOUT AND & 				input_key_buf(0) <> 0%)s 		THEN) 			CALL speak_all_text(msg_no_terminator)E: 			GOSUB process_menu_entry	! Valid command so process it	  6 		ELSE 	IF (terminator_value = DTK$K_TRM_TIMEOUT AND & 				input_key_buf(0) = 0%) 			THENr$ 				CALL speak_all_text(msg_timeout) 				EXIT SUB 			ELSER 				GOSUB  process_menu_entry"	 			END IF  		END IF 	END IFy    NEXT 	 	EXIT SUBU  PROCESS_MENU_ENTRY:  !?  !  Processes the touch tone key string received from the user.h  ! 	IF num_input_keys > 1%d 	THENd 	!< 	!  Only single key commands are valid in this menu.  Inform< 	!  the user that an invalid command was entered and return. 	!& 		CALL speak_all_text(msg_bad_command)0 		illegal_entry_count = illegal_entry_count + 1% 	ELSEL 	    SELECT	input_key_buf(0)0 		CASE = 	DTK$K_TRM_ZERO			! Speak menu help msg* 			CALL speak_text(DTK$K_WAIT, main_menu$) 			illegal_entry_count = 0%   , 		CASE = 	DTK$K_TRM_ONE			! lab results demo 			stat% =  laboratory$ 			if (stat% AND STS$M_SUCCESS) = 0% 			THENe 				EXIT SUB	 			END IF  			illegal_entry_count = 0%E  * 		CASE = 	DTK$K_TRM_TWO			! radiology demo 			stat% = radiology$ 			if (stat% AND STS$M_SUCCESS) = 0% 			THENa 				EXIT SUB	 			END IFh 			illegal_entry_count = 0%d  2 		CASE = 	DTK$K_TRM_THREE			! dectalk product info* 			CALL speak_text(DTK$K_WAIT, dtcfamily$) 			illegal_entry_count = 0%    		CASE ELSE_+ 			CALL speak_text(DTK$K_WAIT, msg_invalid)E1 			illegal_entry_count = illegal_entry_count + 1%S 	   END SELECT 	END IF	 	num_input_keys = 0% 	!B 	! If user enters 3 illegal/incorrect commands, speak help message 	! 	IF illegal_entry_count >= 3 	THEN ) 		CALL speak_text(DTK$K_WAIT, main_menu$)s 		illegal_entry_count = 0% 	END IFt 	RETURNa    END SUB  M  !***************************************************************************iG  !  Load the user dictionary with the words and phonemic pronunciationsPG  !  stored in the sequential file specified in the foreign command linekI  !  invoking the program.  Each line of this file contains the word to beyG  !  defined in the user dictionary followed by a space, followed by the I  !  phonemic pronunciation of the word.  The entry is parsed to find the _N  !  start and finnish of the word and it's replacement.  The word and phonemicM  !  pronunciation are loaded into the user dictionary. If the load dictionarynN  !  command fails, the user is notified and processing is terminated.  ReturnsM  !  SUCCESS if the dictionary is loaded successfully or if no user dictionary.<  !  file name is specified.  Otherwise, FAILURE is returned.     FUNCTION LONG load_dictionary()    %INCLUDE "DTKDEF"  ,   EXTERNAL LONG FUNCTION	DTK$LOAD_DICTIONARY&   EXTERNAL LONG CONSTANT	SS$_NORMAL, & 				DTK$_TOOLONG, DTK$_NOROOMt@   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min  0   COMMON (application_specific)	LONG	voice_id, & 					num_hold_keys, &r 					num_input_keys, & 				BYTE	hold_key_buf(80), & 					input_key_buf(80), &_$ 				STRING	dictionary_file_name = 80  / 	MAP (dictionary) STRING dictionary_entry = 256*( 	DECLARE STRING		diction_word,  phonetic% 	DECLARE LONG		word_count, phonem_endi  
 	sp$ = X'20'Ct 	tab$ = X'09'C  	null_char$ = X'00'Ct 	ON ERROR GOTO ERROR_CHECKG 	IF LEFT$(dictionary_file_name,1) = null_char$	! No dictionary filename, 	THEN 6 	  !  No dictionary was specified in the command line.# 	  !  Return to initialize_dectalk   		load_dictionary = 1% 		exit functioni 	END IFe  A 	OPEN dictionary_file_name AS FILE #1,	ORGANIZATION SEQUENTIAL, &e! 						ACCESS READ, MAP DICTIONARYo 	!E 	! Since there is no timeout associated with the DTK$LOAD_DICTIONARY XC 	! command, it is possible for an application to hang waiting for asF 	! response after issuing the DTK$LOAD_DICTIONARY command.  Therefore,G 	! arm a watchdog timer (6 minutes in this case) to time the loading of4G 	! the entire user dictionary.  If all the entries are not loaded into 	A 	! the user dictionary before the timer expires, then assume thats7 	! something is wrong with the DECtalk module and exit.1 	!: 	CALL set_timer(time_6_min)		! Set system (watchdog) timer        WHILE 1% = 1% 	GET #1o 	! s3 	!  Read in all of the words and substitutions froma8 	!  the sequential file specified in the command string. 	!+ 	word_count = POS(dictionary_entry, sp$, 1)y 	IF word_count = 0%e2 	THEN		word_count = POS(dictionary_entry, tab$, 1) 	END IFl2 	phonem_end = POS(dictionary_entry, null_char$, 1)  7 	diction_word =	SEG$(dictionary_entry, 1, word_count-1) > 	phonetic =	SEG$(dictionary_entry, word_count+1, phonem_end-1)  > 	stat% = DTK$LOAD_DICTIONARY(voice_id, DICTION_WORD, phonetic)1 	IF (stat% = DTK$_TOOLONG OR stat% = DTK$_NOROOM)  	THENt 	     !h9 	     !  These are not generally fatal errors.  However, c: 	     !  they will be treated as such.  In creating a demo9 	     !  program, if words cannot be loaded into the usert> 	     !  dictionary, the programmer should be notified so that@ 	     !  the appropriate action can be taken.  By treating these? 	     !  errors as fatal, the programmer will at least know thel7 	     !  point in the program where the error occurred.a 	     !a
 		CLOSE #1 		CALL error_log(stat%)] 		load_dictionary = 0%' 		EXIT FUNCTION			! Fatal error so exitm/ 	ELSE IF (stat% <> SS$_NORMAL) 	! Fatal failurel
 	     THEN- 			CALL cancel_timer		! Cancel watchdog timero 			CLOSE #1y 			CALL error_log(stat%)6 			CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit 	     END IF 	END IFk	      NEXTD  	!k7 	!  Entire dictionary is loaded so cancel system timer.  	!  DONE:4 	CALL cancel_timer			! Cancel system(watchdog) timer$ 	CLOSE #1				! Close dictionary file 	load_dictionary = 1%i  EXIT FUNCTION  
  ERROR_CHECK: ( 	IF ERR = 11%		! IF End of File is found 	THEN]
 		RESUME DONEC 	ELSE  	   CALL error_log(VMSSTATUS)" 	   RESUME HEREa HERE:  	   load_dictionary = 0% 	   EXIT FUNCTIONt 	END IFh
  END FUNCTIONe  M  !***************************************************************************rH  !  DECtalk stopped speaking because it was in autostop keypad mode whenG  !  it received a Touch Tone Key from the user.  First, send DECtalk a eK  !  right square bracket "]" just in case speech was stopped while speaking M  !  phonemic text. Then, restart speech (using DTK$SET_SPEECH_MODE) and resetr6  !  the speaking voice and rate (using DTK$SET_VOICE).  !  SUB restart()    %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT	STS$M_SUCCESS/   EXTERNAL LONG FUNCTION	DTK$SET_SPEECH_MODE, &  				DTK$SET_VOICEe  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_mineI   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, &a# 		 period_pause_duration, speech_onh-   COMMON (application_specific)	LONG	voice_idn      rsbracket$    = "]"  6   DECLARE LONG old_mode				! Current mode before reset  ) 	CALL speak_text( DTK$K_WAIT, rsbracket$)n 	! 	!  Set speakig on 	! 	CALL set_timer(Time_45_sec); 	stat% = DTK$SET_SPEECH_MODE(voice_id, speech_on, old_mode)t 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENe 		CALL error_log(stat%)M5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exita 	END IFn 	!% 	!  Reset the voice and speaking rate  	CALL set_timer(Time_45_sec)8 	stat% = DTK$SET_VOICE(voice_id, voice, speaking_rate, &0 				comma_pause_duration, period_pause_duration) 	CALL cancel_timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENT 		CALL error_log(stat%)e5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exite 	END IFp    END SUB  M  !***************************************************************************DE  !  End the current user session.  Since the DTK$HANGUP_PHONE commanduC  !  does not set a timeout, and it requests DECtalk to send a phone G  !  status, a watchdog timer is set to insure that the application doessG  !  not hang (if DECtalk fails).  If a longer timeout period is needed, H  !  adjust the value of the parameter moved into SET_TIMER_STRING beforeM  !  performing "set_timer".  After the watchdog timer is set, speak a goodbyemI  !  message to the caller and then hangup the phone.  The goodbye messagerB  !  spoken can be changed by modifying the text in "msg_goodbye".   !  SUB end_call ()  )   EXTERNAL LONG CONSTANT	STS$M_SUCCESS, &n 				SS$_TIMEOUT, & 				DTK$_ONHOOK	  -   EXTERNAL LONG FUNCTION 	DTK$HANGUP_PHONE, &O 				DTK$READ_KEYSTROKE, &( 				DTK$SPEAK_TEXT  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_minm-   COMMON (application_specific)	LONG	voice_idN/   COMMON (results_reporting)    LONG	call_countr  M   msg_goodbye$  = "Thank you for calling Digital's [l'aebraxtoriy] Results "&sB 	+ "Reporting Demonstration.  For more information, please call "& 	+ "1, 800, 8 3 2, 6 2 7 7. "    	IF call_count = 0%e 	THEN  		call_count = 1%A 	ELSE IF call_count = 1%
 	    THEN  		call_count = 0%  	    END IFr 	END IF : 	CALL set_timer(time_6_min)		! Set system (watchdog) timer 	!$ 	!  Say goodbye and hangup the phone 	!1 	stat% = DTK$HANGUP_PHONE(voice_id, msg_goodbye$)t* 	CALL cancel_timer			! Cancel system timer" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENs 		CALL error_log(stat%) 5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exity 	END IF0 	!B 	! Get rid of any winks that may have been generated by the caller? 	! hanging up in the middle of the goodbye message.  This worksE( 	! around clears the internal WINK flag. 	!         timeout% = 1%  	WHILE 1% = 1%  	    CALL set_timer(Time_45_sec): 	    stat% = DTK$READ_KEYSTROKE(voice_id, xx%, , timeout%) 	    CALL cancel_timer4 	    IF (stat% = DTK$_ONHOOK OR stat% = SS$_TIMEOUT)	 	    THENu 		!1/ 	  	!  Clear remaining winks that may have been%3 		!  detected before DECtalk hung up the telephone.  		! $ 	        CALL set_timer(Time_45_sec)> 	        stat% = DTK$READ_KEYSTROKE(voice_id, xx%, , timeout%) 	        CALL cancel_timer# 		IF (stat% AND STS$M_SUCCESS) = 0%*
 	        THEN* 			CALL error_log(stat%)6 			CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit 	        END IFd 	        EXIT SUBu+ 	    ELSE IF (stat% AND STS$M_SUCCESS) = 0%  	         THEN 			CALL error_log(stat%)6 			CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exit 	         END IF 	    END IFn 	NEXTe  END SUB  J  !  ----------------------------------------------------------------------J  !  Speak all text -- disable autostop keypad, speak text in prompt using :  !  "speak_text". If autostop was set, re-enable autostop.  !#  SUB speak_all_text (STRING prompt)     %INCLUDE "DTKDEF"  &   EXTERNAL LONG CONSTANT	STS$M_SUCCESS,   EXTERNAL LONG FUNCTION	DTK$SET_KEYPAD_MODE  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_minnI   COMMON (dt_features) LONG voice, speaking_rate, comma_pause_duration, &iP         period_pause_duration, speech_on, new_mode, number_of_rings, keypad_mode-   COMMON (application_specific)	LONG	voice_id$     DECLARE LONG	keypad_on     keypad_on = DTK$K_KEYPAD_ONe 	!F 	!  If autostop keypad mode is enabled (keymode = DTK$K_KEYPAD_AUTO), 1 	!  then enable the keypad without autostop mode.L 	!C 	IF (keypad_mode = DTK$K_KEYPAD_AUTO)	! Keypad is in autostop mode	_ 	THENm7 		CALL set_timer(Time_45_sec)	! Set the watchdog timer	)2 		stat% = DTK$SET_KEYPAD_MODE(voice_id, keypad_on)1 		CALL cancel_timer		! Cancel the watchdog timer	e# 		IF (stat% AND STS$M_SUCCESS) = 0%M 		THEN 			CALL error_log(stat%)  			CALL LIB$STOP(stat% BY VALUE) 		END IF 	END IFT  ( 	!  Send text to DECtalk to be spoken.  = 	!  Specify the mode as DTK$K_WAIT so that text is completely_< 	!  spoken before the keypad is re-enabled in autostop mode.  $ 	CALL speak_text(DTK$K_WAIT, prompt)  ' 	!  If autostop keypad mode was enableda9 	!  (keypad_mode = DTK$K_KEYPAD_AUTO), then re-enable it.n 	!D 	IF (keypad_mode = DTK$K_KEYPAD_AUTO) ! Keypad was in autostop mode	 	THEN 4 		CALL set_timer(Time_45_sec)	! Set watchdog timer		4 		stat% = DTK$SET_KEYPAD_MODE(voice_id, keypad_mode)1 		CALL cancel_timer		! Cancel the watchdog timer	n# 		IF (stat% AND STS$M_SUCCESS) = 0%. 		THEN 			CALL error_log(stat%)  			CALL LIB$STOP(stat% BY VALUE) 		END IF 	END IFI  END SUB  M  !***************************************************************************,.  !  Sends the prompt (specified by prompt) to 1  !  the DECtalk to be spoken.  Returns SUCCESS ifm>  !  everything is spoken o.k.  Otherwise, FAILURE is returned.  !  7  !  NOTE:  If DTK$SPEAK_TEXT is called with mode set tor8  !	   DTK$K_WAIT or DTK$K_STATUS, a phone status requestA  !	   is sent from DECtalk.  Since there is no timeout associatede>  !	   with this request, a system timer should be set (to someG  !	   exteremely long value (16 minutes) to insure that the applicationm  !	   does not hang.  !8  SUB speak_text (LONG return_status_mode, STRING prompt)    %INCLUDE "DTKDEF"  )   EXTERNAL LONG CONSTANT	STS$M_SUCCESS, &d 				SS$_NORMAL'   EXTERNAL LONG FUNCTION	DTK$SPEAK_TEXTn  M   COMMON (constants) STRING time_45_sec, time_90_sec, time_6_min, time_16_minc  -   COMMON (application_specific)	LONG	voice_idt 	! 	!  Speak the text: 	CALL set_timer(time_16_min)	! Set system (watchdog) timer= 	stat% = DTK$SPEAK_TEXT(voice_id, prompt, return_status_mode)	) 	CALL cancel_timer		! Cancel system timer_ 	IF (stat% <> SS$_NORMAL)_ 	THENA 		CALL error_log(stat%),5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitO 	END IFT  END SUB  I  ! **********************************************************************e/  !	Log error to the operator console  "OPER11".   !N  !  Take the error number, input to SYS$GETMSG to get the system message text.P  !  Format the message text with the specific terminal line for that applicationL  !  "process" (using SYS$FAO), and call SYS$SENOPR with the error structure.  !H  !  NOTE:  the DTK$ errors that occur will have the %DTK- facility name,B  !	  but not the error message text, just the error number.  It isG  !	  anticipated that these messages will be included in future VMS/RTLa  !	  releases.  !!  SUB error_log(LONG error_number)w  B  %INCLUDE "$OPCDEF" %FROM %LIBRARY "SYS$LIBRARY:BASIC$STARLET.TLB"  #   EXTERNAL LONG CONSTANT	SS$_NORMALt#   EXTERNAL LONG FUNCTION	SYS$FAO, &  				SYS$SNDOPR, &c 				SYS$GETMSG  0   COMMON (application_specific)	LONG	voice_id, & 					num_hold_keys, &m 					num_input_keys, & 				BYTE	hold_key_buf(80) , &  					input_key_buf(80), &I' 				STRING	dictionary_file_name = 80, &1 					terminal_line  B   MAP	(error_struct) LONG opc$type_target, LONG OPC$L_MS_RQSTID, & 			STRING error_text = 120+   MAP	(error_struct) STRING error_msg = 128t%   MAP   (temp)  STRING error_buf = 80*  +   DECLARE STRING CONSTANT filler = "  ON  "*3   DECLARE STRING CONSTANT control_str = "!AD!AS!AD"c   DECLARE LONG buf_len  Q      temp% = SYS$GETMSG(error_number by value, buf_len, error_buf, 15% by value,)k  !A  ! Set message target to OPER11, and the message type to RQ_RQST.eD  ! For more information on sending messages to an operators terminal"  ! see the System Services manual.  !>     opc$type_target = (OPC$M_NM_OPER11 * 256%) OR OPC$_RQ_RQST  6  	temp% = SYS$FAO(control_str, buf_len, error_text,		&*  				buf_len by value, error_buf by ref,	&/  				filler, 5% by value, terminal_line by ref)S2  	WHILE MID$(error_text, buf_len + 1, 1) <> X"00"C,  		MID$(error_text, buf_len + 1, 1) = X"00"C  		buf_len = buf_len + 1  	NEXT,  	stat% = SYS$SNDOPR(error_msg, 0% by value)3   	IF (stat% <> SS$_NORMAL)		! Send to oper failed	k  	THEN5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exite	  	END IF C  END SUB  M  !***************************************************************************4J  !  Sets the system (watchdog) timer to expire "sec" seconds in the futureI  !  by invoking the "SYS$SETIMR" system service.  SYS$BINTIM is passed a sL  !  character string in the format "D HH:MM:SS", where D is Days, H is HoursH  !  M is minutes etc.  The output of BINTIM is the quadword delta_time ,/  !  which gets passed as input to SYS$SETIMR.  ,  !"  SUB set_timer(STRING time_string)  ( 	EXTERNAL LONG CONSTANT	STS$M_SUCCESS, & 				SS$_TIMEOUTS% 	EXTERNAL LONG FUNCTION	SYS$SETIMR, &e 				SYS$BINTIM: 	EXTERNAL LONG		LIB$SIGNAL 	! Indicate exception condition% 	MAP (quadword) LONG delta_time, FILL*  , 	stat% = SYS$BINTIM(time_string, delta_time)# 	IF (stat% AND STS$M_SUCCESS)  = 0%e 	THENK 		CALL error_log(stat%)!5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitn 	END IF   K 	stat%= SYS$SETIMR( ,delta_time, LIB$SIGNAL BY VALUE, SS$_TIMEOUT BY VALUE) # 	IF (stat% AND STS$M_SUCCESS)  = 0%n 	THENe 		CALL error_log(stat%)!5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitR 	END IFe  END SUB  J  !  ----------------------------------------------------------------------$  !  Cancel the system watchdog timer  !  SUB cancel_timer()   %  EXTERNAL LONG CONSTANT	STS$M_SUCCESSd?  EXTERNAL LONG FUNCTION	SYS$CANTIM		! Cancel SYS$SETIMR requestE  6 	stat% = SYS$CANTIM(SS$_TIMEOUT BY VALUE, 0% BY VALUE)" 	IF (stat% AND STS$M_SUCCESS) = 0% 	THENN 		CALL error_log(stat%)	5 		CALL LIB$STOP(stat% BY VALUE)	! Fatal error so exitN 	END IFt  END SUB