@echo off
REM ------------------------------------------------------------------------
REM This is a general 'make' batch file. It needs to be called with certain
REM parameters, so unless you know what they are, just use one of the
REM screen-reader specific make files, such as makegen, makeve, etc.
REM ------------------------------------------------------------------------
REM first parameter is drive to create batch file on.
REM second parameter is a parameter to give to s_talk and xs_talk
REM third  parameter is a parameter to give to s_talk and xs_talk
REM fourth parameter is name of .st file
REM parameters 5,6,7, and 8 are name of screen reader
REM ------------------------------------------------------------------------
REM General flow of this file is to check the environment space, then check
REM the parameters from the command line to see if they are the right format.
REM We then check and standardize the drive letter.
REM Next step is to run setsmart for the correct screen reader.
REM Next, we run findtalk, which will return an error level indicating what
REM port the SmarTalk was found on, the interrupt it was using, and the time
REM delay (T parameter) needed for the port. The errorlevel is used to set
REM some environment variables, and then we use the values to create a
REM SMARTALK.BAT file in the SmarTalk directory and in the root directory.

set test=ABCDEFGHIJKLMNOPQRSTUVWXYZ
if %test%==ABCDEFGHIJKLMNOPQRSTUVWXYZ goto ENV_OK
goto ENV_BAD

:ENV_OK
set test=
if .%1. == .. goto INSTRUCT
if not exist %sd%\smartalk\%4.st goto INSTRUCT
if %2 == . goto NOP2
set p2=%2
goto CHECK3
:NOP2
set p2=
:CHECK3
if %3 == . goto NOP3
set p3=%3
goto CHECK1
:NOP3
set p3=

:CHECK1
if %1==a goto SET_A
if %1==a: goto SET_A
if %1==A goto SET_A
if %1==A: goto SET_A
if %1==b goto SET_B
if %1==b: goto SET_B
if %1==B goto SET_B
if %1==B: goto SET_B
if %1==c goto SET_C
if %1==c: goto SET_C
if %1==C goto SET_C
if %1==C: goto SET_C
if %1==d goto SET_D
if %1==d: goto SET_D
if %1==D goto SET_D
if %1==D: goto SET_D
if %1==e goto SET_E
if %1==e: goto SET_E
if %1==E goto SET_E
if %1==E: goto SET_E
if %1==f goto SET_F
if %1==f: goto SET_F
if %1==F goto SET_F
if %1==F: goto SET_F
if %1==g goto SET_G
if %1==g: goto SET_G
if %1==G goto SET_G
if %1==G: goto SET_G
echo Unknown Drive letter %1
echo Drive letters are from A to G
goto END
:SET_A
set sd=a:
goto begin
:SET_B
set sd=b:
goto begin
:SET_C
set sd=c:
goto begin
:SET_D
set sd=d:
goto begin
:SET_E
set sd=e:
goto begin
:SET_F
set sd=f:
goto begin
:SET_G
set sd=g:
:begin

%sd%\smartalk\setsmart < %sd%\smartalk\%4.st > nul
echo.
%sd%\smartalk\findtalk Q1
if errorlevel 250 goto NOT_CON
if errorlevel 200 goto PORT3
if errorlevel 100 goto PORT2
if errorlevel 0   goto PORT1
:NOT_CON
echo Please connect SmarTalk to your computer and try again.
goto END

:PORT1
set st=L1
set ss=LPT1
goto CHECK_INT

:PORT2
set st=L2
set ss=LPT2
goto CHECK_INT

:PORT3
set st=L3
set ss=LPT3

:CHECK_INT
if errorlevel 220 goto INT7
if errorlevel 210 goto INT5
if errorlevel 200 goto INT0

if errorlevel 120 goto INT7
if errorlevel 110 goto INT5
if errorlevel 100 goto INT0

if errorlevel 20 goto INT7
if errorlevel 10 goto INT5
if errorlevel 0 goto INT0
:INT0
set in=I0
goto CHECK_TIME

:INT5
set in=I5
goto CHECK_TIME

:INT7
set in=I7

:CHECK_TIME
if errorlevel 229 goto TIME9
if errorlevel 226 goto TIME6
if errorlevel 223 goto TIME3
if errorlevel 220 goto TIME0

if errorlevel 219 goto TIME9
if errorlevel 216 goto TIME6
if errorlevel 213 goto TIME3
if errorlevel 210 goto TIME0

if errorlevel 209 goto TIME9
if errorlevel 206 goto TIME6
if errorlevel 203 goto TIME3
if errorlevel 200 goto TIME0

if errorlevel 129 goto TIME9
if errorlevel 126 goto TIME6
if errorlevel 123 goto TIME3
if errorlevel 120 goto TIME0

if errorlevel 119 goto TIME9
if errorlevel 116 goto TIME6
if errorlevel 113 goto TIME3
if errorlevel 110 goto TIME0

if errorlevel 109 goto TIME9
if errorlevel 106 goto TIME6
if errorlevel 103 goto TIME3
if errorlevel 100 goto TIME0

if errorlevel 29 goto TIME9
if errorlevel 26 goto TIME6
if errorlevel 23 goto TIME3
if errorlevel 20 goto TIME0

if errorlevel 19 goto TIME9
if errorlevel 16 goto TIME6
if errorlevel 13 goto TIME3
if errorlevel 10 goto TIME0

if errorlevel 9 goto TIME9
if errorlevel 6 goto TIME6
if errorlevel 3 goto TIME3
if errorlevel 0 goto TIME0

:TIME9
set ti=T9
goto mk_smart

:TIME6
set ti=T6
goto mk_smart

:TIME3
set ti=T3
goto mk_smart

:TIME0
set ti=T0

:mk_smart
echo @echo off > %sd%\smartalk.bat
echo echo SmarTalk Speech Synthesizer Program Automated Functions, Inc. 1995 >> %sd%\smartalk.bat
echo echo This batch file is for %5 %6 %7 %8 on %ss%, using %in% and %ti%. >> %sd%\smartalk.bat
echo %sd%\smartalk\st_check %%1 %%2 %%3 %%4 %%5 %%6 %%7 %%8 %%9 >> %sd%\smartalk.bat
echo if errorlevel 1 goto norm >> %sd%\smartalk.bat
echo %sd%\smartalk\xs_talk %st% %in% %ti% f3 s1 %p2% %p3% %%1 %%2 %%3 %%4 %%5 %%6 %%7 %%8 %%9 >> %sd%\smartalk.bat
echo echo SmarTalk tables loaded in XMS >> %sd%\smartalk.bat
echo goto bye>> %sd%\smartalk.bat
echo :norm>> %sd%\smartalk.bat
echo %sd%\smartalk\s_talk %st% %in% %ti% f3 s1 %p2% %p3% %%1 %%2 %%3 %%4 %%5 %%6 %%7 %%8 %%9 >> %sd%\smartalk.bat
echo echo SmarTalk tables loaded in conventional memory >> %sd%\smartalk.bat
echo :bye >> %sd%\smartalk.bat
echo %sd%\smartalk\st_run %%1 %%2 %%3 %%4 %%5 %%6 %%7 %%8 %%9 >> %sd%\smartalk.bat
echo echo for %5 %6 %7 %8 # %ss% >> %sd%\smartalk.bat
echo echo Now Run %5 %6 %7 %8 >> %sd%\smartalk.bat

REM this program replaces # with greater than in the named file
%sd%\smartalk\grsub %sd%\smartalk.bat
copy %sd%\smartalk.bat %sd%\smartalk > nul
echo You may now run the SMARTALK batch file to start the speech.
echo You then run %5 %6 %7 %8
call smartalk.bat
goto END

:INSTRUCT
echo.
echo This is a general 'make' batch file. It needs to be called with certain
echo parameters, so unless you know what they are, just use one of the
echo screen-reader specific make files, such as makegen, makeve, etc.
echo.
goto END

:ENV_BAD
set test=
echo.
echo There is not enough environment space to make the SmarTalk batch 
echo file for %5 %6 %7 %8
echo Please increase your environment space and try again.
echo.
echo You can increase your environment space by changing your CONFIG.SYS file
echo to have a line like the one below:
echo.
echo SHELL=COMMAND.COM /e:1024
echo.
echo The number after the /e: is the size of your environment.
echo.
echo 
goto END

:END
set st=
set sd=
set ss=
set ti=


