//
//  Header file for ttusbd.dll
//
//  Copyright (c) 2000,2003 Access Solutions
//

#ifdef __cplusplus
extern "C" {
#endif

// Write a byte to the TripleTalk USB.
// This function will block.
__declspec(dllimport) void __cdecl USBTT_WriteByte(int value);

// Write a byte to the TripleTalk USB without blocking.
// Use this function to send a 0x18 to shut the synth up.
__declspec(dllimport) void __cdecl USBTT_WriteByteImmediate(int value);

// Check to see if it is ok to send a byte.
__declspec(dllimport) int __cdecl USBTT_ReadyCheck();

// Read a byte from synth.
// Use this function to retrieve index marks.
// An index mark of "-1" means busy. Index marks are between 0 and 99.
__declspec(dllimport) int __cdecl USBTT_ReadByte();

// Check if dll was able to establish a handle to wdm driver.
// A return value of 1 means yes, 0=no.
__declspec(dllimport) int __cdecl USBTT_CheckWdmStatus();

// Write a string of text to the TripleTalk.
__declspec(dllexport) int __cdecl USBTT_WriteString(char *Msg, int szMsg);

#ifdef __cplusplus
 }
#endif

/*
 * This pragma instructs the linker to include ttusbd.lib in the link, thus
 * removing the need to manually add it to the project.
 */
#pragma comment(lib, "ttusbd.lib")


